/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;

import java.io.IOException;

import java.net.InetSocketAddress;

import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * @author ehsroha
 * @reveiwed ehsroha 2006-nov-14
 */
public class TCPListener extends LinkBase implements Link {
    private static final String TRANSPORT_TCP = "TCP";
    private Logger _log = LogUtil.SIP_LOGGER.getLogger();
    private ServerSocketChannel _serverSocketChannel = null;
    private final boolean _acceptRegister;
    private TargetTuple localTargetTuple;
    
    public TCPListener(TargetTuple aLocalTargetTuple, OLDNetworkManager n, Layer l,
        boolean acceptRegister) {
        super(n, l);
        _acceptRegister = acceptRegister;
        localTargetTuple = aLocalTargetTuple;
    }
    
    private boolean isAcceptRegister() {
        return _acceptRegister;
    }

    public String getTransport() {
        return TRANSPORT_TCP;
    }

    public TargetTuple getTargetTuple() {
        return null;
    }

    public boolean isOpen() {
        return (_serverSocketChannel != null) ? _serverSocketChannel.isOpen()
                                              : false;
    }

    public void open() throws IOException {
        _serverSocketChannel = ServerSocketChannel.open();
        _serverSocketChannel.configureBlocking(false);

        _serverSocketChannel.socket().bind(localTargetTuple.getSocketAddress());
        _serverSocketChannel.register(_networkManager.getSelector(),
            SelectionKey.OP_ACCEPT, this);

        // register with read event
        _networkManager.getSelector().wakeup();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Opening:\n" + localTargetTuple);
        }
    }

    protected void closeImpl() throws IOException {
        _serverSocketChannel.close();
    }

    public Object call() throws Exception {
        try {
            SocketChannel newChannel = _serverSocketChannel.accept();
            new TCPLink(newChannel, _networkManager, _nextLayer,
                isAcceptRegister());
        } catch (IOException ioe) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "", ioe);
            }
        }
        return null;
    }

    public void dispatch(SipServletRequestImpl req) {
        // TODO Auto-generated method stub
    }

    public void dispatch(SipServletResponseImpl resp) {
        // TODO Auto-generated method stub
    }

    public InetSocketAddress getLocal() {
        return (InetSocketAddress) _serverSocketChannel.socket()
                                                       .getLocalSocketAddress();
    }

    /**
     * Returns always null
     *
     * @return always null
     */
    public InetSocketAddress getRemote() {
        return null;
    }

    public SelectableChannel getSelectableChannel() {
        return _serverSocketChannel;
    }

    public void write(InetSocketAddress remote, ByteBuffer buffer) {
        throw new UnsupportedOperationException(
            "Can't write to a TCP listener socket!");
    }

    public String getInfo() {
        return getClass().getName();
    }
}
