/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;

import java.io.IOException;

import java.net.InetSocketAddress;

import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * @author ehsroha
 * @reveiwed ehsroha 2006-nov-14
 */
public class UDPListener extends LinkBase implements Link {
    protected static final String _transport = "UDP";

    // // Max UDP Datagram unit
    protected static final int UDP_BUFFER_SIZE = 65535;
    protected Logger _log = LogUtil.SIP_LOGGER.getLogger();
    protected DatagramChannel _dgramChannel = null;
    protected int _port = -1;
    protected TargetTuple localTargetTuple;
    
    public UDPListener(TargetTuple aLocalTargetTuple, OLDNetworkManager n, Layer l) {
        super(n, l);
        localTargetTuple = aLocalTargetTuple;
    }

    public String getTransport() {
        return _transport;
    }

    public TargetTuple getTargetTuple() {
        return null;
    }

    public boolean isOpen() {
        return (_dgramChannel != null) ? _dgramChannel.isOpen() : false;
    }

    public void open() throws IOException {
        _dgramChannel = DatagramChannel.open();
        _dgramChannel.configureBlocking(false);

        _dgramChannel.socket().bind(localTargetTuple.getSocketAddress());
        // channel.socket().setSoTimeout( timeoutValue );
        _dgramChannel.register(_networkManager.getSelector(),
            SelectionKey.OP_READ, this);
        _readBuffer = ByteBuffer.allocate(UDP_BUFFER_SIZE);
        _writeBuffer = ByteBuffer.allocate(UDP_BUFFER_SIZE);

        // register with read event
        _networkManager.getSelector().wakeup();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Opening:\n" + localTargetTuple);
        }
    }

    protected void closeImpl() throws IOException {
        _dgramChannel.close();
    }

    public Object call() throws Exception {
        _readMutex.lock();

        InetSocketAddress remote = null;

        try {
            remote = (InetSocketAddress) _dgramChannel.receive(_readBuffer);
        } catch (IOException ioe) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Caught IOException: ", ioe);
            }

            _readMutex.unlock();
        } catch (Throwable t) {
            // FIXME alarm for e.g. OutOfMemoryError
            _log.log(Level.SEVERE, "Caught Throwable: ", t);
            _readMutex.unlock();
        } finally {
            _networkManager.releaseSelectorSemaphore();
        }

        _readBuffer.flip();

        if (_readBuffer.hasRemaining()) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE,
                    "In Dgram :" + Thread.currentThread().getName());
                _log.log(Level.FINE, "Buffer = " + _readBuffer.limit());
            }

            handleMessage(_readBuffer, getLocal(), SipTransports.UDP_PROT,
                remote);
        } else {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE,
                    "Zero bytes in UDP ByteBuffer = " + _readBuffer.limit());
            }

            _readBuffer.clear();
            _readMutex.unlock();
        }
        return null;
    }

    public void write(InetSocketAddress remote, ByteBuffer message)
        throws IOException {
        while (message.hasRemaining()) {
            _dgramChannel.send(message, remote);
        }
    }

    public InetSocketAddress getLocal() {
        return (InetSocketAddress) _dgramChannel.socket().getLocalSocketAddress();
    }

    public InetSocketAddress getRemote() {
        return (InetSocketAddress) _dgramChannel.socket()
                                                .getRemoteSocketAddress();
    }

    public SelectableChannel getSelectableChannel() {
        return _dgramChannel;
    }

    public String getInfo() {
        return getClass().getName();
    }
}
