/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.ericsson.ssa.container.callflow;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.container.sim.SipServletFacade;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

public class ComplexReporter implements Reporter {
    
    private Vector<Reporter> reporterList = new Vector<Reporter>();


    public void addReporter(Reporter r) {
        if(r != null )
            reporterList.add(r);
    }
    
    public int countReporters() {
        return reporterList.size();
    }

    public void reportPre(Layer l, SipServletRequest req) {
       for(Reporter r : reporterList){
           r.reportPre(l, req);
       }
    }

    public void reportPost(Layer l, SipServletRequest req) {
       for(Reporter r : reporterList){
           r.reportPost(l, req);
       }
    }

    public void reportPre(Layer l, SipServletResponse resp) {
       for(Reporter r : reporterList){
           r.reportPre(l, resp);
       }
    }

    public void reportPost(Layer l, SipServletResponse resp) {
       for(Reporter r : reporterList){
           r.reportPost(l, resp);
       }
    }

    public void reportPre(SipServletFacade s, SipServletRequest req) {
       for(Reporter r : reporterList){
           r.reportPre(s, req);
       }
    }
    
    public void reportPost(SipServletFacade s, SipServletRequest req) {
       for(Reporter r : reporterList){
           r.reportPost(s, req);
       }
    }    

    public void reportPost(SipServletFacade s, SipServletRequest req, Exception e) {
       for(Reporter r : reporterList){
           r.reportPost(s, req, e);
       }
    }    
}
