/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container.datacentric;

import com.sun.enterprise.server.ApplicationServer;


/**
 * This is a utility for accessing and querying the Data Centric entities, for example the
 * consistent hash for all server instances in the cluster.
 * <p>
 * This is an abstract singleton for which the concrete implementation should be provided at
 * start-up of the container.
 *
 */
public abstract class DataCentricUtil {
    private static DataCentricUtil instance = new DefaultInstance(); // The instance

    protected DataCentricUtil() {
    }

    /**
     * Sets the instance.
     * @param instance a concrete implementation of this class.
     */
    public static void setInstance(DataCentricUtil instance) {
        DataCentricUtil.instance = instance;
    }

    /**
     * Gets the instance.
     * @return
     */
    public static DataCentricUtil getInstance() {
        return instance;
    }

    /**
     * Gets the actual server instance (i.e, with regard to the actual cluster shape) that 
     * is mapped to the specified key.
     * @param key the key
     * @return the server instance that is mapped to the specified key
     */
    public abstract String getActualServerInstance(String key);

    /**
     * Gets the server instance that would be mapped to the specified key in case the cluster 
     * is complete (i.e. all servers are working).
     * @param key the key
     * @return the ideal server instance that is mapped to the specified key
     */
    public abstract String getIdealServerInstance(String key);

    /**
     * Checks if the specified key should be handled by the current (local) instance.
     * @param key the key
     * @return true if the key is mapped to the local server instance; otherwise false
     */
    public abstract boolean isLocal(String key);
    
    /**
     * Gets a key that is local for this instance regardless of cluster state, i.e. based on the ideal cluster.
     * @return a key that is local for this instance
     */
    public abstract String getLocalKey();
    
    /**
     * Checks if Data Centric is enabled on this node.
     * @return true if enabled; otherwise false
     */
    public boolean isDataCentricEnabled() {
        return false;
    }
    
    private static class DefaultInstance extends DataCentricUtil {

        @Override
        public String getActualServerInstance(String key) {
            return ApplicationServer.getServerContext().getInstanceName();
        }

        @Override
        public String getIdealServerInstance(String key) {
            return ApplicationServer.getServerContext().getInstanceName();
        }

        @Override
        public boolean isLocal(String key) {
            return true;
        }

        @Override
        public String getLocalKey() {
            return "";
        }
        
    }
}
