/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container.deployer;

import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;

import java.io.File;
import java.io.IOException;

import java.net.URL;


public class HostDeployer {
    StandardHost host;

    public HostDeployer(StandardHost host) {
        this.host = host;
    }

    public synchronized void install(String contextPath, URL war)
        throws IOException {
        String url = war.toString();
        String docBase = null;
        boolean isWAR = false;

        if (url.startsWith("jar:")) {
            url = url.substring(4, url.length() - 2);

            if (!url.toLowerCase().endsWith(".war") &&
                    !url.toLowerCase().endsWith(".sar")) {
                throw new IllegalArgumentException();
            }

            isWAR = true;
        }

        if (url.startsWith("file://")) {
            docBase = url.substring(7);
        } else if (url.startsWith("file:")) {
            docBase = url.substring(5);
        } else {
            throw new IllegalArgumentException();
        }

        // Determine if directory/war to install is in the host appBase
        boolean isAppBase = false;
        File appBase = new File(host.getAppBase());

        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"),
                    host.getAppBase());
        }

        File contextFile = new File(docBase);
        File baseDir = contextFile.getParentFile();

        if (appBase.getCanonicalPath().equals(baseDir.getCanonicalPath())) {
            isAppBase = true;
        }

        // Expand war file if host wants wars unpacked
        if (isWAR && host.isUnpackWARs()) {
            if (contextPath.equals("")) {
                docBase = ExpandWar.expand(host, war, "/ROOT");
            } else {
                docBase = ExpandWar.expand(host, war, contextPath);
            }
        }

        // Install the new application
        try {
            Class clazz = Class.forName(host.getContextClass());
            Context context = (Context) clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);

            if (context instanceof Lifecycle) {
                clazz = Class.forName(host.getConfigClass());

                LifecycleListener listener = (LifecycleListener) clazz.newInstance();
                ((Lifecycle) context).addLifecycleListener(listener);
            }

            host.fireContainerEvent("pre_install", context);
            host.addChild(context);
            host.fireContainerEvent("install", context);
        } catch (ClassNotFoundException e) {
        } catch (Exception e) {
            throw new IOException(e.toString());
        }
    }
}
