/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;


/**
 * Corresponds to the ejb-local-ref element.
 * <p>
 * This element is used for the declaration of a reference to an enterprise
 * bean's local home. The declaration consists of: <br> - an optional
 * description <br> - the EJB reference name used in the code of THE_COMPONENT
 * that's referencing the enterprise bean <br> - the expected type of the
 * referenced enterprise bean <br> - the expected local home and local
 * interfaces of the referenced enterprise bean <br> - optional ejb-link
 * information, used to specify the referenced enterprise bean
 *
 * @author qdesmar
 * @since 4-Dec-2003 (EAS 3.0)
 */
public class EjbLocalReference implements Serializable {
    private static final long serialVersionUID = 3257854263907662137L;
    private String description;
    private String name;
    private String type;
    private String localHome;
    private String local;
    private String ejbLink;

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     */
    public void setType(String type) {
        if (!EjbReferenceType.contains(type)) {
            throw new RuntimeException("Ejb reference type must be of " +
                EjbReferenceType.printNames());
        }

        this.type = type;
    }

    /**
     * @return
     */
    public String getLocalHome() {
        return localHome;
    }

    /**
     * @param localHome
     */
    public void setLocalHome(String localHome) {
        this.localHome = localHome;
    }

    /**
     * @return
     */
    public String getLocal() {
        return local;
    }

    /**
     * @param local
     */
    public void setLocal(String local) {
        this.local = local;
    }

    /**
     * @return
     */
    public String getEjbLink() {
        return ejbLink;
    }

    /**
     * @param ejbLink
     */
    public void setEjbLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }
}
