/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;


public class Servlet implements Serializable {
    private static final long serialVersionUID = 3258412845946254135L;
    private String applicationName;
    private String smallIcon;
    private String largeIcon;
    private String servletName;
    private String displayName;
    private String description;
    private String servletClass;
    private Map<String, Parameter> initParameters;
    private int loadOnStartup;
    private String runAsDescription;
    private String runAsRoleName;
    private Collection<SecurityRoleReference> securityRoleReferences;
	private String packageName;

    /**
     * Default constructor.
     */
    public Servlet() {
    }

    /**
     * @param parameter
     */
    public void addInitParameter(Parameter parameter) {
        if (initParameters == null) {
            initParameters = new HashMap<String, Parameter>();
        }

        if (initParameters.get(parameter.getName()) != null) {
            throw new RuntimeException("Each parameter name must be unique " +
                "in the initialization parameter");
        }

        initParameters.put(parameter.getName(), parameter);
    }

    /**
     * @param securityRoleReference
     */
    public void addSecurityRoleReference(
        SecurityRoleReference securityRoleReference) {
        if (securityRoleReferences == null) {
            securityRoleReferences = new ArrayList<SecurityRoleReference>();
        }

        securityRoleReferences.add(securityRoleReference);
    }

    /**
     * @return
     */
    public Map getInitParameters() {
        return initParameters;
    }

    /**
     * @param initParameterName
     * @return
     */
    public Parameter getInitParameter(String initParameterName) {
        return (Parameter) initParameters.get(initParameterName);
    }

    /**
     * @return
     */
    public Collection<SecurityRoleReference> getSecurityRoleReferences() {
        return securityRoleReferences;
    }

    /**
     * @return
     */
    public String getSmallIcon() {
        return smallIcon;
    }

    /**
     * @param smallIcon
     */
    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    /**
     * @return
     */
    public String getLargeIcon() {
        return largeIcon;
    }

    /**
     * @param largeIcon
     */
    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    /**
     * @return
     */
    public String getServletName() {
        return servletName;
    }

    /**
     * @param servletName
     */
    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    /**
     * @return
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */
    public String getServletClass() {
        return servletClass;
    }

    /**
     * @param servletClass
     */
    public void setServletClass(String servletClass) {
        this.servletClass = servletClass;
    }

    /**
     * @return
     */
    public int getLoadOnStartup() {
        return loadOnStartup;
    }

    /**
     * @param loadOnStartup
     */
    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    /**
     * This method will be called by the digester.
     * @param loadOnStartup
     */
    public void setLoadOnStartup(String loadOnStartup) {
        // This method will fix the problem when the app. developer
        // write <load-on-startup/> with on tag. The digester will
        // this method with an empty String.
        if (!loadOnStartup.equals("")) {
            this.loadOnStartup = Integer.valueOf(loadOnStartup);
        }
    }

    /**
     * @return
     */
    public String getRunAsDescription() {
        return runAsDescription;
    }

    /**
     * @param runAsDescription
     */
    public void setRunAsDescription(String runAsDescription) {
        this.runAsDescription = runAsDescription;
    }

    /**
     * @return
     */
    public String getRunAsRoleName() {
        return runAsRoleName;
    }

    /**
     * @param runAsRoleName
     */
    public void setRunAsRoleName(String runAsRoleName) {
        this.runAsRoleName = runAsRoleName;
    }

	public String getApplicationName() {
		return applicationName;
	}

	public void setApplicationName(String applicationName) {
		this.applicationName = applicationName;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}
}
