/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;
import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jvnet.glassfish.comms.deployment.backend.SecurityConstraint;

import org.jvnet.glassfish.comms.deployment.backend.SipApplicationBase;


public class SipApplication implements Serializable, SipApplicationBase {
    private static final long serialVersionUID = 3258415023411114551L;
    public static final int UNKNOWN_TIMEOUT_VALUE = Integer.MIN_VALUE;
    private String smallIcon;
    private String largeIcon;
    private String displayName;
    private String description;
    private boolean distributable;
    private Map<String, Parameter> contextParameters;
    private Collection<String> listeners;
    private LinkedHashMap<String, Servlet> annotatedServlets = new LinkedHashMap<String, Servlet>();
    private Map<String, Servlet> servlets;
    private Map<String, ServletMapping> servletMappings;
    private long proxyConfigSequentialSearchTimeout;
    private int sessionConfigTimeout = UNKNOWN_TIMEOUT_VALUE;
    private Collection<ResourceEnvironmentReference> resourceEnvironmentReferences;
    private Collection<ResourceReference> resourceReferences;
    private Collection<SecurityConstraint> securityConstraints;
    private String loginConfigAuthMethod;
    private String loginConfigRealmName;
    private Map<String, SecurityRole> securityRoles;
    private Collection<EnvironmentEntry> environmentEntries;
    private Collection<EjbReference> ejbReferences;
    private Collection<EjbLocalReference> ejbLocalReferences;
    private String moduleName;
    private int version;
    private String defaultServlet;
    private String appName;
    private String packageName;

    Method sipApplicationKeyMethod;
	private String mainServletName;
    
    /**
     *
     *
     *
     */
    public SipApplication() {
    }

    /**
     * @param servlet
     */
    public void addServlet(Servlet servlet) {
        if (servlets == null) {
            servlets = new LinkedHashMap<String, Servlet>();
        }

        if (servlets.get(servlet.getServletName()) != null) {
            throw new RuntimeException("Cannot have more than one servlet " +
                "with the same name in the sip deployment descriptor");
        }

        servlets.put(servlet.getServletName(), servlet);

        //Default servlet is the first one
        if ((defaultServlet == null) && (servlet != null)) {
            defaultServlet = servlet.getServletName();
        }
    }

    /**
     * @param servletMapping
     */
    public void addServletMapping(ServletMapping servletMapping) {
        if (servletMappings == null) {
            servletMappings = new HashMap<String, ServletMapping>();
        }

        /* This use to be a validation for 
        if (servlets.get(servletMapping.getServletName()) == null) {
            throw new RuntimeException("Cannot have a servlet mapping which " +
                "servlet name doesn't match a servlet defined in the " +
                "sip deployment descriptor");
        }
        */

        if (servletMappings.get(servletMapping.getServletName()) != null) {
            throw new RuntimeException("Cannot have more than one servlet " +
                "mapping per servlet name in the sip deployment descriptor");
        }

        servletMappings.put(servletMapping.getServletName(), servletMapping);
    }

    /**
     * @param listener
     */
    public void addListener(String listener) {
        if (listeners == null) {
            listeners = new ArrayList<String>();
        }

        listeners.add(listener);
    }

    /**
     * @param parameter
     */
    public void addContextParameter(Parameter parameter) {
        if (contextParameters == null) {
            contextParameters = new HashMap<String, Parameter>();
        }

        if (contextParameters.get(parameter.getName()) != null) {
            throw new RuntimeException("Each parameter name must be unique " +
                "in the context parameter");
        }

        contextParameters.put(parameter.getName(), parameter);
    }

    /**
     * @param reference
     */
    public void addResourceEnvironmentReference(
        ResourceEnvironmentReference reference) {
        if (resourceEnvironmentReferences == null) {
            resourceEnvironmentReferences = new ArrayList<ResourceEnvironmentReference>();
        }

        resourceEnvironmentReferences.add(reference);
    }

    /**
     * @param reference
     */
    public void addResourceReference(ResourceReference reference) {
        if (resourceReferences == null) {
            resourceReferences = new ArrayList<ResourceReference>();
        }

        resourceReferences.add(reference);
    }

    /**
     * @param constraint
     */
    public void addSecurityConstraint(SecurityConstraint constraint) {
        if (securityConstraints == null) {
            securityConstraints = new ArrayList<SecurityConstraint>();
        }

        securityConstraints.add(constraint);
    }

    /**
     * @param environmentEntry
     */
    public void addEnvironmentEntry(EnvironmentEntry environmentEntry) {
        if (environmentEntries == null) {
            environmentEntries = new ArrayList<EnvironmentEntry>();
        }

        environmentEntries.add(environmentEntry);
    }

    /**
     * @param ejbReference
     */
    public void addEjbReference(EjbReference ejbReference) {
        if (ejbReferences == null) {
            ejbReferences = new ArrayList<EjbReference>();
        }

        ejbReferences.add(ejbReference);
    }

    /**
     * @param ejbLocalReference
     */
    public void addEjbLocalReference(EjbLocalReference ejbLocalReference) {
        if (ejbLocalReferences == null) {
            ejbLocalReferences = new ArrayList<EjbLocalReference>();
        }

        ejbLocalReferences.add(ejbLocalReference);
    }

    /**
     * @param securityRole
     */
    public void addSecurityRole(SecurityRole securityRole) {
        if (securityRoles == null) {
            securityRoles = new HashMap<String, SecurityRole>();
        }

        securityRoles.put(securityRole.getName(), securityRole);
    }

    /**
     * @return
     */
    public Map<String, Servlet> getServlets() {
        return (servlets != null) ? servlets : Collections.EMPTY_MAP;
    }

    /**
     * @param servletName
     * @return
     */
    public Servlet getServlet(String servletName) {
        return (Servlet) servlets.get(servletName);
    }

    /**
     * First servlet that is added.
     * @return servlet name
     */
    public String getDefaultServlet() {
        return defaultServlet;
    }

    /**
     * @return
     */
    public Map<String, ServletMapping> getServletMappings() {
        return (servletMappings != null) ? servletMappings : Collections.EMPTY_MAP;
    }

    /**
     * @param servletName
     * @return
     */
    public ServletMapping getServletMappings(String servletName) {
        return (ServletMapping) servletMappings.get(servletName);
    }

    /**
     * @return
     */
    public Map<String, Parameter> getContextParameters() {
        return (contextParameters != null) ? contextParameters
                                           : Collections.EMPTY_MAP;
    }

    /**
     * @param contextParameterName
     * @return
     */
    public Parameter getContextParameter(String contextParameterName) {
        return (Parameter) contextParameters.get(contextParameterName);
    }

    /**
     * @return
     */
    public Collection<EjbLocalReference> getEjbLocalReferences() {
        return (ejbLocalReferences != null) ? ejbLocalReferences
                                            : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public Collection<EjbReference> getEjbReferences() {
        return (ejbReferences != null) ? ejbReferences : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public Collection<EnvironmentEntry> getEnvironmentEntries() {
        return (environmentEntries != null) ? environmentEntries
                                            : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public Collection<String> getListeners() {
        return (listeners != null) ? listeners : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public Collection<ResourceEnvironmentReference> getResourceEnvironmentReferences() {
        return (resourceEnvironmentReferences != null)
        ? resourceEnvironmentReferences : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public Collection<ResourceReference> getResourceReferences() {
        return (resourceReferences != null) ? resourceReferences
                                            : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public Collection<SecurityConstraint> getSecurityConstraints() {
        return (securityConstraints != null) ? securityConstraints
                                             : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public Map<String, SecurityRole> getSecurityRoles() {
        return (securityRoles != null) ? securityRoles : Collections.EMPTY_MAP;
    }

    /**
     * @param roleName
     * @return
     */
    public SecurityRole getSecurityRoles(String roleName) {
        return (SecurityRole) securityRoles.get(roleName);
    }

    /**
     * @return
     */
    public String getSmallIcon() {
        return smallIcon;
    }

    /**
     * @param smallIcon
     */
    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    /**
     * @return
     */
    public String getLargeIcon() {
        return largeIcon;
    }

    /**
     * @param largeIcon
     */
    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    /**
     * @return
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */
    public boolean isDistributable() {
        return distributable;
    }

    /**
     *
     *
     *
     */
    public void setDistributable() {
        this.distributable = true;
    }

    /**
     * @return
     */
    public long getProxyConfigSequentialSearchTimeout() {
        return proxyConfigSequentialSearchTimeout;
    }

    /**
     * @param proxyConfigSequentialSearchTimeout
     */
    public void setProxyConfigSequentialSearchTimeout(
        String proxyConfigSequentialSearchTimeout) {
        this.proxyConfigSequentialSearchTimeout = Long.valueOf(proxyConfigSequentialSearchTimeout);
    }

    public void setProxyConfigSequentialSearchTimeout(
            int proxyConfigSequentialSearchTimeout) {
            this.proxyConfigSequentialSearchTimeout = proxyConfigSequentialSearchTimeout;
    }
    
    /**
     * @return
     */
    public int getSessionConfigTimeout() {
        return sessionConfigTimeout;
    }

    /**
     * @param sessionConfigTimeout
     */
    public void setSessionConfigTimeout(String sessionConfigTimeout) {
        if (!sessionConfigTimeout.equals("")) {
            this.sessionConfigTimeout = Integer.valueOf(sessionConfigTimeout);
        }
    }
    
    public void setSessionConfigTimeout(int sessionConfigTimeout) {
    	this.sessionConfigTimeout = sessionConfigTimeout;
    }

    /**
     * @return
     */
    public String getLoginConfigAuthMethod() {
        return loginConfigAuthMethod;
    }

    /**
     * @param loginConfigAuthMethod
     */
    public void setLoginConfigAuthMethod(String loginConfigAuthMethod) {
        if (!LoginAuthentication.contains(loginConfigAuthMethod)) {
            throw new RuntimeException("Legal values for the auth-method are " +
                LoginAuthentication.printNames());
        }

        this.loginConfigAuthMethod = loginConfigAuthMethod;
    }

    /**
     * @return
     */
    public String getLoginConfigRealmName() {
        return loginConfigRealmName;
    }

    /**
     * @param loginConfigRealmName
     */
    public void setLoginConfigRealmName(String loginConfigRealmName) {
        this.loginConfigRealmName = loginConfigRealmName;
    }

    /**
     * @return
     */
    public String getModuleName() {
        return moduleName;
    }

    /**
     * @param moduleName
     */
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    /**
     * @return
     */
    public int getVersion() {
        return version;
    }

    /**
     * @param version
     */
    public void setVersion(int version) {
        this.version = version;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

	public void setSipApplicationKey(Method sipApplicationKeyMethod) {
		this.sipApplicationKeyMethod = sipApplicationKeyMethod;
	}
	
	public Method getSipApplicationKey() {
		return this.sipApplicationKeyMethod;
	}

	
	public void setMainservletName(String mainServlet) {
		this.mainServletName = mainServlet;
	}
	
	public String getMainservletName() {
		return this.mainServletName;
	}
	
	public void addAnnotatedServlets( String servletName, Servlet servlet) {
		annotatedServlets.put(servletName, servlet);
	}
	
	public Map<String, Servlet> getAnnotatedServlets() {
		return annotatedServlets;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}
	
}
