/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.dd;

import com.sun.org.apache.commons.digester.Digester;

import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.io.InputStream;

import java.net.URL;

import java.util.jar.JarEntry;
import java.util.jar.JarFile;


public class SipParser {
    private static final String SIP_XML_RULES_FILE = "com/ericsson/ssa/dd/sip-digester-rules.xml";
    private static final String SIP_EAS_XML_RULES_FILE = "com/ericsson/ssa/dd/sip-eas-digester-rules.xml";

    private SipParser() {
    }

    /**
     * Parses the sip.xml & the sip-eas.xml files from the archive and validates
     * the content of the archive according to the deployment descriptor
     * specifications.
     *
     * @param archive
     *        The archive containing the sip.xml & sip-eas.xml files
     * @return The <code>SipApplication</code> object built from the parsing of
     *         both xml files
     * @throws java.io.IOException
     * @throws se.ericsson.eas.oam.api.exception.EASModuleDeployException
     * @throws org.xml.sax.SAXException
     */
    public static SipApplication parse(JarFile archive)
        throws IOException, ModuleDeployException, SAXException {
        InputStream sipXml = null;

        try {
            JarEntry sipXmlJarEntry = archive.getJarEntry(SipSpecification.SIP_XML_DESCRIPTOR_NAME);
            sipXml = archive.getInputStream(sipXmlJarEntry);

            return parse(sipXml);
        } finally {
            if (sipXml != null) {
                sipXml.close();
            }
        }
    }

    public static SipApplication parse(InputStream sipXml)
        throws IOException, ModuleDeployException, SAXException {
        URL sipXmlRules = SipParser.class.getClassLoader()
                                         .getResource(SIP_XML_RULES_FILE);

        // Parse the sip.xml file, validate against the dtd, and extract
        // its content to build the SipApplication object
        Digester digester = new Digester();

        // Digester digester = DigesterLoader.createDigester(sipXmlRules);
        EntityResolver entityResolver = new SipEntityResolver();
        digester.setValidating(false);
        digester.setClassLoader(SipParser.class.getClassLoader());
        digester.setEntityResolver(entityResolver);
        digester.resolveEntity(null, null);
        digester.setValidating(false);

        SipDeploymentDescriptorRuleSet ruleSet = new SipDeploymentDescriptorRuleSet();
        ruleSet.addRuleInstances(digester);

        SipApplication sipApplication = (SipApplication) digester.parse(sipXml);

        return sipApplication;
    }
}
