/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.servlet.sip.SipServletRequest;


public class SubDomainOfOperand extends Operand {
    /**
          *
          */
    private static final long serialVersionUID = 1L;

    /**
    * Specifies a variable
    */
    private String variable;

    /**
     * Specifies a literal string value that is used to specify rules
     */
    private String value;

    /**
     * Evaluate the condition
     *
     * @param object
     *        The object to evaluate
     * @return True if the operand or operator evaluation is satisfied, false
     *         otherwise
     */
    public boolean evaluate(Object object) {
        String actualValue = getAttributeValue(variable,
                (SipServletRequest) object);

        if (actualValue.endsWith(value)) {
            int len1 = actualValue.length();
            int len2 = value.length();

            return ((len1 == len2) ||
            (actualValue.charAt(len1 - len2 - 1) == '.'));
        }

        return false;

        //throw new UnsupportedOperationException("Method needs implementation");
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws SipParserException {
        throw new UnsupportedOperationException("Method needs implementation");
    }

    /**
     * @return
     */
    public String getVariable() {
        return variable;
    }

    /**
     * @param variable
     */
    public void setVariable(String variable) {
        this.variable = variable;
    }

    /**
     * @return
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }
}
