/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.fm;

import java.util.HashMap;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;

import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * This class handles notification and alarms to be raised.
 *
 * @author edtugdi, epiesan
 * @since 2005-aug-11
 */
public class FmEventSender {
    private final static Logger LOGGER = LogUtil.SIP_LOGGER.getLogger();

    //-------- NOTIFICATIONS ---//

    /**
     * Application Deployed Successfully Notification
     * @param contextName The application name
     */
    public static void applicationDeployedSuccessfully(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".application_deployed_successfully_notification",contextName);

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_DEPLOYMENT_FINISHED_SUCCESSFULLY,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Started Notification
     * @param contextName The application name
     *
     */
    public static void applicationDeploymentStarted(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".application_deployment_started_notification", contextName);

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_DEPLOYMENT_STARTED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Failed Notification
     * @param contextName The application name
     * @param reason The reason to failure
     */
    public static void applicationDeploymentFailed(String contextName,
        String reason) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        param.put("Reason to failure", reason);
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".application_deployment_failed_notification", contextName);

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_DEPLOYMENT_FAILED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Undeployed Successfully Notification
     * @param contextName The application name
     */
    public static void applicationUndeployedSuccessfully(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".application_undeployed_successfully_notification", contextName);

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_UNDEPLOYMENT_FINISHED_SUCCESSFULLY,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Started Notification
     * @param contextName The application name
     *
     */
    public static void applicationUndeploymentStarted(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".application_undeployment_started_notification", contextName);

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_UNDEPLOYMENT_STARTED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Failed Notification
     * @param contextName The application name
     * @param reason The reason to failure
     */
    public static void applicationUndeploymentFailed(String contextName,
        String reason) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        param.put("Reason to failure", reason);
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".application_undeployment_failed_notification", contextName);

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_UNDEPLOYMENT_FAILED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Servlet Initialization Failed Notification
     * @param contextName The application name
     * @param servletName The servlet name
     * @param reason The reason to fail
     */
    public static void servletInitializationFailed(String contextName,
        String servletName, String reason) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        param.put("Servlet", servletName);
        param.put("Reason to failure", reason);
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".servlet_initialization_failed_notification",contextName);

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_SERVLET_INITIALIZATION_FAILED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    //------ ALARMS --------/

    /**
     * Clear all existing Traffic Module alarms.
     */
    public static void clearAlarms() {
        clearAlarmCpuLoadLimitExceeded();
    }

    public static void clearAlarmCpuLoadLimitExceeded() {
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".clear_cpu_loadlimit_exceeded_alarm");

        /*
        Alarm alarm = FmFactory.getInstance().getAlarmManager();
        try
        {
           alarm.clearAlarm(FmTypes.OBJECT_TYPE_EAS, FmTypes.INSTANCE_SIP_CONTAINER,
                 FmTypes.ALARM_CPU_LOAD_LIMIT_EXCEEDED, null, true);  // Fix for HH34467
        }
        catch(FmCannotSendRequestException e)
        {
           logger.log(Level.SEVERE, "Got an exception when clearing the alarm", e);
        }
        */
    }

    /**
     * Raise an alarm when CPU load limit exceeded.
     *
     * @param reason Reason to failure.
     */
    public static void raiseAlarmCpuLoadLimitExceeded(String reason) {
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
            ".raise_cpu_loadlimit_exceeded_alarm",reason);

        /*
        if (reason == null)
        {
           reason = FmTypes.DESC_ALARM_CPU_LOAD_LIMIT_EXCEEDED;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Specific Event MOC", FmTypes.OBJECT_TYPE_EAS);
        param.put("Reason for issued alarm", reason);
        param.put("IRP Cause", "310");
        param.put("Specific Problems", FmTypes.CPU_ALARM_PROBABLE_CAUSE);

        Alarm alarm = FmFactory.getInstance().getAlarmManager();
        try
        {
           alarm.raiseAlarm(FmTypes.ALARM_TYPE_PROCESSING_ERROR,
                 FmTypes.OBJECT_TYPE_EAS,
                 FmTypes.INSTANCE_SIP_CONTAINER,
                 FmTypes.ALARM_CPU_LOAD_LIMIT_EXCEEDED,
                 FmTypes.ALARM_SEVERITY_CRITICAL,
                 FmTypes.CPU_ALARM_PROBABLE_CAUSE,
                 param,
                 true);       // Fix for HH34467
        }
        catch(FmCannotSendRequestException e)
        {
           logger.log(Level.SEVERE, "Got an exception when try to raise an alarm", e);
        }
        */
    }

    public static void raiseAlarmMemoryLoadLimitExceeded(String reason) {
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
        ".raise_memory_loadlimit_exceeded_alarm", reason);
        
    }

    public static void clearAlarmMemoryLoadLimitExceeded() {
        LOGGER.log(Level.WARNING, FmEventSender.class.getCanonicalName()  +
        ".clear_memory_loadlimit_exceeded_alarm");
        
    }
}
