/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.router;

import java.io.Serializable;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;

import javax.servlet.sip.SipApplicationRouter;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipApplicationRoutingRegion;
import javax.servlet.sip.SipRouteModifier;
import javax.servlet.sip.SipServletReadOnlyRequest;

import org.jvnet.glassfish.comms.util.LogUtil;
import java.util.logging.Logger;


public class AlphabeticalRouter implements SipApplicationRouter {
    private SortedSet<String> deployedApps = new TreeSet<String>();
    
	private static Logger theirLog = LogUtil.AR_LOGGER.getLogger();
	private static final String LOGPREFIX = 
		"com.ericsson.ssa.router.AlphabeticalRouter.";

    public void init() {
    	if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "initempty");
        }
    	deployedApps = new TreeSet<String>();
}
    
    public void init(List<String> applications) {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "init");
        }
        
        logApplications(applications);

        deployedApps = new TreeSet<String>(applications);
    }

    public void destroy() {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "destroy");
        }

        deployedApps = null;
    }

    public void applicationDeployed(List<String> applications) {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "applications_deployed");
        }

        for (String app : applications) {
            if (!deployedApps.contains(app)) {
                if (theirLog.isLoggable(Level.FINE)) {
            		theirLog.log(Level.FINE, LOGPREFIX + "application_added", app);
                }

                deployedApps.add(app);
            } else {
                if (theirLog.isLoggable(Level.FINE)) {
            		theirLog.log(Level.FINE, LOGPREFIX + "application_upgraded", app);
                }
            }
        }
    }

    public void applicationUndeployed(List<String> applications) {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "applications_undeployed");
        }

        // guard against nullpointerException. When server is shut down,
        // destroy might be called before undeploying the applications. Although
        // that is a bug in itself (issues #26 and #485), a little robustness
        // cannot hurt. 
        if (deployedApps != null){
            for (String app : applications) {
                boolean removed = deployedApps.remove(app);

                if (theirLog.isLoggable(Level.FINE)) {
                            theirLog.log(Level.FINE, LOGPREFIX + "application_removed", new Object[] { app, removed });
                }
            }
        } else {
            theirLog.warning(LOGPREFIX + "could_not_undeploy");
        }
    }

    /*
     * Only checks the state info since each request is traversed by all
     * applications in the alphabetical order
     */

	public SipApplicationRouterInfo getNextApplication(
			SipServletReadOnlyRequest initialRequest,
			SipApplicationRoutingRegion region,
			SipApplicationRoutingDirective directive, Serializable stateInfo) {
		
        if (theirLog.isLoggable(Level.FINEST)) {
    		theirLog.log(Level.FINEST, LOGPREFIX + "getnextapp", 
                    new Object[] { initialRequest, region, directive, stateInfo });
        }
        			
        SipApplicationRouterInfo info = null;
        String subscriberURI = 
        	initialRequest.getRequestURI().toString();

        String app = null;

        if (stateInfo == null) { 
        	// First invocation of AlphabeticalRouter
        	if (theirLog.isLoggable(Level.FINEST)) {
             	theirLog.log(Level.FINEST, LOGPREFIX + "stateinfonull");
        	}
            if( initialRequest.getLocalAddr() == null ) {
                SipRouteModifier modifier = SipRouteModifier.NO_ROUTE;

                info = new SipApplicationRouterInfo(
            		null, // next application name, external so null
            		null, // routing region, external so null
            		null, // served subscriber URI, external so null
            		null, // route, modifier set to NO_ROUTE so irrelevant
            		modifier, 
            		null); // stateinfo TODO should we pass existing state info?
            }
            // Issue 783, guard for empty list
            else if (deployedApps != null && !deployedApps.isEmpty()) { 
                try {
                    app = deployedApps.first();
                } catch (RuntimeException re) {
                    theirLog.log(Level.SEVERE, LOGPREFIX + 
                    "firstapperror", re);              
                }
            }
        } else {
            boolean match = false;

            for (String x : deployedApps) {
                if (match) {
                    app = x;
                	if (theirLog.isLoggable(Level.FINEST)) {
                   		theirLog.log(Level.FINEST, LOGPREFIX + "nextappfound", x); 
                	}
                    break;
                }

                if (stateInfo.equals(x)) {
                    match = true;
                }
            }
        }

        if (app == null) {
        	// No application found, time to leave the container.
        	if (theirLog.isLoggable(Level.FINEST)) {
             	theirLog.log(Level.FINEST, LOGPREFIX + "noappfound");
        	}
        	
            SipRouteModifier modifier = SipRouteModifier.NO_ROUTE;

            info = new SipApplicationRouterInfo(
            		null, // next application name, external so null
            		null, // routing region, external so null
            		null, // served subscriber URI, external so null
            		null, // route, modifier set to NO_ROUTE so irrelevant
            		modifier, 
            		null); // stateinfo TODO should we pass existing state info?
        } else { 
        	if (theirLog.isLoggable(Level.FINEST)) {
             	theirLog.log(Level.FINEST, LOGPREFIX + "routinginternally");
        	}
        	
        	// Internal application selected. The route modifier is set to 
        	// NO_ROUTE. This means (JSR289) the container should disregard
        	// the route in the info object and inspect the app name instead.
            SipRouteModifier modifier = SipRouteModifier.NO_ROUTE;
            info = new SipApplicationRouterInfo(
        		app, // next application name
        		region, // region in which app will serve, use unchanged
        		subscriberURI, // just use what came in
        		null, // route, modifier set to NO_ROUTE so irrelevant
        		modifier,
                app ); // application name used as stateinfo
        }

        return info;
    }
        
        private void logApplications(List<String> applications){
            if (theirLog.isLoggable(Level.FINEST)) {
                for (String app : applications){
                    theirLog.log(Level.FINEST, 
                        LOGPREFIX + "applicationname", app);
                }
            }
        }
}
