/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;


/**
 * This class represents something that can be either a Address object or a
 * plain non-interpreted string value. It captures the duality nature of headers.
 *
 * @author qmaghes
 *
 */
public class AddressOrValue implements Cloneable {
    /**
     *  String representation.
     */
    public String value = null;

    /**
     *  Address representation.
     */
    public Address address = null;

    /**
     *  Parameterable representation.
     */
    public Parameterable parameterable = null;

    private AddressOrValue() {
    }

    public AddressOrValue(String value) {
        if (value == null) {
            throw new NullPointerException("Requires proper value");
        }

        this.value = value;
    }

    public AddressOrValue(Address address) {
        if (address == null) {
            throw new NullPointerException("Requires proper address");
        }

        this.address = address;
    }

    public AddressOrValue(Parameterable parameterable) {
        if (parameterable == null) {
            throw new NullPointerException("Requires proper Parameterable");
        }

        this.parameterable = parameterable;
    }

    public Object clone() {
        AddressOrValue clone = new AddressOrValue();
        clone.value = value;

        if (address != null) {
            clone.address = (Address) ((AddressImpl) address).clone(true, true);
        }

        if (parameterable != null) {
            clone.parameterable = (Parameterable) ((ParameterableImpl) parameterable).clone(true);
        }

        return clone;
    }

    public Address getAddressValue() throws ServletParseException {
        if (address == null) {
            if (value != null) {
                address = SipFactoryImpl.getInstance().createAddress(value);
                value = null;
            }

            if (parameterable != null) {
                address = SipFactoryImpl.getInstance()
                                        .createAddress(parameterable.toString());
                parameterable = null;
            }
        }

        return address;
    }

    public void setAddressValue(Address address) {
        this.address = address;
        this.parameterable = null;
        this.value = null;
    }

    public Parameterable getParameterableValue() throws ServletParseException {
        if (parameterable == null) {
            if (address != null) {
                return (Parameterable) address;
            }

            if (value != null) {
                parameterable = SipFactoryImpl.getInstance()
                                              .createParameterable(value);
                value = null;
            }
        }

        return parameterable;
    }

    public void setParameterableValue(Parameterable parameterable) {
        this.address = null;
        this.parameterable = parameterable;
        this.value = null;
    }

    public String toString() {
        // Future improvement:
        // Doing address.toString() every time might be
        // resource consuming. A state consisting of the address hashCode
        // might be used. In such a implementation the hash code of the address
        // object is calculated and if it matches the saved state value can be returned
        // directly.
        // Such an implementation requires a good hashCode() implementation in AddressImpl.
        if (address != null) {
            return address.toString();
        } else if (parameterable != null) {
            return parameterable.toString();
        } else if (value != null) {
            return value;
        }

        return "";
    }

    public void setValue(String value) {
        this.address = null;
        this.parameterable = null;
        this.value = value;
    }
}
