/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;


/**
 * Validation of the CSeq header.
 *
 *
 * @author qmaghes
 *
 */
public class CSeqHeaderValidator extends BasicMandatoryHeaderValidator {
    public static final long LIMIT_32BIT_UNSIGNED = 0x100000000L;

    public CSeqHeaderValidator() {
        super(Header.CSEQ);
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader(Header.CSEQ);

        if ((header == null) || (header.getValue() == null) ||
                (header.getValue().length() == 0)) {
            return false;
        }

        String value = header.getValue();

        // CSeq is "1*DIGIT LWS METHOD" 
        String[] parts = splitLWS(value);

        if (parts.length != 2) {
            return false;
        }

        return isNumber(parts[0]) && isMethod(parts[1]);
    }

    /**
     * Check is <code>method<method> matches "Method" i.e. "extension-method" according to rfc 3261.
     *
     * @param method
     * @return
     */
    private boolean isMethod(String method) {
        return isToken(method);
    }

    /**
     *         Check that the integer part is an unsigned 32 bit int.
     *
     * @param numberPart
     * @return
     */
    private boolean isNumber(String numberPart) {
        try {
            long cseqNumber = Long.parseLong(numberPart);

            if ((cseqNumber < 0) || (cseqNumber >= LIMIT_32BIT_UNSIGNED)) {
                return false;
            }

            // number part ok
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }
}
