/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import java.util.regex.Pattern;


/**
 * Validation of call ID. A call id is one or two words separated by @ sign. See rfc 3261 for definition of word
 *
 *
 * @author qmaghes
 *
 */
public class CallIDValidator extends BasicMandatoryHeaderValidator {
    // Regexp that also accepts single quote which is not correct RFC 3261, but is axxepted as
    // rfc4475 (Sip Torture Text messages) allows it.
    private static final String REGEXP_WORD = "[a-zA-Z1234567890\\-.!%*_+`�~()<>:\\\\\\\"/\\[\\]?{}']+";
    private static final String REGEXP_CALLID = "(" + REGEXP_WORD + ")(@" +
        REGEXP_WORD + "){0,1}";
    private Pattern callIDPattern = Pattern.compile(REGEXP_CALLID);

    public CallIDValidator() {
        super(Header.CALL_ID);
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader(Header.CALL_ID);

        if ((header == null) || (header.getValue() == null) ||
                (header.getValue().length() == 0)) {
            return false;
        }

        String value = header.getValue();

        return callIDPattern.matcher(value).matches();
    }
}
