/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/**
 * Copyright (c) Ericsson AB 2007
 *
 * All Rights Reserved. Reproduction in whole or in part is prohibited
 * without the written consent of the copyright owner.
 *
 * ERICSSON MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. ERICSSON SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package com.ericsson.ssa.sip;

import java.util.ArrayList;
import java.util.List;


/**
 * Part of the Proxy implementation. There might be several CreatedTargetSet per
 * Proxy.
 *
 * @author ehsroha
 */
public class CreatedTargetSet extends TargetSet {
    private List<TargetSet> _targetSets = new ArrayList<TargetSet>(0);

    /**
     * The constructor of the CreatedTargetSet implementation.
     *
     * @param p
     *           the Proxy this set belongs to
     * @param recurse
     *           whether recurse is enabled or not
     * @param timeout
     *           the timeout for proxing
     */
    public CreatedTargetSet(ProxyImpl p) {
        super(p);
    }

    @Override
    protected List<TargetSet> getTargetSets() {
        return _targetSets;
    }

    public void add(TargetSet t) {
        _targetSets.add(t);
        t.setParent(this);
    }

    public boolean hasNext() {
        return false;
    }

    public void next() {
        // nothing to do
    }

    public SipServletResponseImpl findBestResponse() {
        return null;
    }

    public void proxyTo() throws IllegalStateException {
        throw new IllegalStateException("this target set is only for creation");
    }

    public void cancel() throws IllegalStateException {
        throw new IllegalStateException("this target set is only for creation");
    }

    /**
     * Always return false
     *
     * @return always false
     */
    @Override
    public boolean isStarted() {
        return false;
    }

    /**
     * Always return false
     *
     * @return always false
     */
    @Override
    public boolean getParallel() {
        return false;
    }

    /**
     * Always return false
     *
     * @return always false
     */
    @Override
    public boolean getRecurse() {
        return false;
    }
}
