/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import org.jvnet.glassfish.comms.util.LogUtil;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.Set;

/**
 * Utility class for I/O related tasks such as serialization.
 *
 * @author jluehe
 */
class IOUtil {

    private static final Logger logger = LogUtil.SIP_LOGGER.getLogger();

    /**
     * Dummy attribute key that gets written out if the attribute value
     * is not an instance of Serializable.
     */
    private static final transient String DUMMY_KEY = "__DUMMY_KEY__";

    /*
     * Dummy attribute value that gets written out if the attribute value is
     * an instance of Serializable, but an object in its object graph is not.
     */
    private static final transient String DUMMY_VALUE = "__DUMMY_VALUE__";

    /**
     * Writes the given session attributes to the given ObjectOutputStream.
     */
    static void writeSessionAttributes(Map<String, Object> sessionAttrs,
                                       ObjectOutputStream out)
                    throws IOException {

        if (sessionAttrs == null) {
            out.writeInt(0);
            return;
        }

        out.writeInt(sessionAttrs.size());

        for (Map.Entry<String, Object> entry : sessionAttrs.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Serializable)) {
                // Write dummy key
                out.writeObject(DUMMY_KEY);
            } else {
                out.writeObject(entry.getKey());
                try {
                    out.writeObject(entry.getValue());
                } catch (NotSerializableException e) {
                    logger.log(Level.WARNING,
                        "Unable to serialize session attribute " +
                        entry.getKey(), e);
                    out.writeObject(DUMMY_VALUE);
                } catch (IOException ioe) {
                    if (ioe.getCause() instanceof NotSerializableException) {
                        logger.log(Level.WARNING,
                            "Unable to serialize session attribute " +
                            entry.getKey(), ioe.getCause());
                        out.writeObject(DUMMY_VALUE);
                    } else {
                        throw ioe;
                    }
                }
            } 
        }
    }

    /**
     * Reads any session attributes from the given ObjectInputStream.
     */
    static Map<String, Object> readSessionAttributes(ObjectInputStream in)
            throws IOException, ClassNotFoundException {

        Map<String, Object> result = null;

        int size = in.readInt();
        if (size > 0) {
            result = new HashMap<String, Object>();    
            for (int i=0; i<size; i++) {
                String key = (String) in.readObject();
                if (!DUMMY_KEY.equals(key)) {
                    Object value = in.readObject();
                    if (!(value instanceof String) ||
                            !value.equals(DUMMY_VALUE)) {
                        result.put(key, value);
                    }
                }
            }
        }

        return result;
    }
}
