/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.container.callflow.Reporter;
import java.lang.reflect.Method;


/**
 * @author ekrigro
 */
public final class LayerHelper {
    public static void next(SipServletRequestImpl req, Layer layer,
        Layer nextLayer) {
        if (nextLayer == null) {
            layer.dispatch(req);
        } else {
            Reporter reporter = nextLayer.getReporter();
            if(reporter != null) {
                reporter.reportPre(nextLayer, req);
            }
            
            nextLayer.next(req);
            
            if(reporter != null) {
                reporter.reportPost(nextLayer, req);
            }            
        }
    }

    public static void next(SipServletResponseImpl resp, Layer layer,
        Layer nextLayer) {
        if (nextLayer == null) {
            layer.dispatch(resp);
        } else {
            Reporter reporter = nextLayer.getReporter();
            if(reporter != null) {
                reporter.reportPre(nextLayer, resp);
            }
            
            nextLayer.next(resp);
            
            if(reporter != null) {
                reporter.reportPost(nextLayer, resp);
            }            
        }
    }

    /**
     * Returns the singelton instance of a class implementing Layer Requirements
     * of the class as specified in "className" 1. The class has to implement the
     * Singelton pattern with the method getInstance() to retreive the singelton
     * instance. 2. The class has to implement the Layer interface
     *
     * @param className
     *        The fully qualified classname of the class implementing the Layer
     * @return A singelton instance of the class as specified by "className" OR
     *         null if the class does not comply to the condition of step 1 and 2
     */
    public static Layer getInstance(String className) {
        try {
            Class clazz = Class.forName(className);
            Method method = clazz.getMethod("getInstance", (Class[]) null);

            return (Layer) method.invoke((Object) null, (Object[]) null);
        } catch (Exception e) {
            return null;
        }
    }
}
