/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;


/**
 * Since the container uses lazy parsing every component in the container
 * should throw this exception whenever it notices that something is wrong.
 * in most cases it will be due to catching an exception.
 * If that is not the case it is recomended that the component tries to answer
 * using the normal stack layer chain.
 * This is a last effort and it will answe in the network layer with a 4xx response.
 * So the recommendation is to only set the code to 4XX
 *
 * @author ekrigro
 * @since 2005-maj-11
 *
 */
public class LazyParsingException extends RuntimeException {
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    private int _sipErrorCode = 400;
    private String _reasonPhrase = null;

    public LazyParsingException(int code, String reason) {
        super(reason);
        _reasonPhrase = reason;
        _sipErrorCode = code;
    }

    public LazyParsingException(int code, Throwable exception) {
        super(exception);
        _sipErrorCode = code;
    }

    public LazyParsingException(int code, String reason, Throwable exception) {
        super(reason, exception);
        _reasonPhrase = reason;
        _sipErrorCode = code;
    }

    public LazyParsingException(Throwable exception) {
        super(exception);

        // TODO Auto-generated constructor stub
    }

    public int getSipErrorCode() {
        return _sipErrorCode;
    }

    public String getReasonPhrase() {
        return _reasonPhrase;
    }
}
