/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSessionsUtil;
import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.config.ConvergedContextImpl;

/**
 * Implementation class of SipSessionsUtil interface.
 *
 * @author jluehe
 */
public class SipSessionsUtilImpl implements SipSessionsUtil {
    private ConvergedContextImpl ctx;
    private ConcurrentHashMap<Object, String> linkedSessions =
        new ConcurrentHashMap<Object, String>();

    // Does this SipSessionsUtil have cross-SAR visibility, i.e., does
    // it have access to the SipSessionManagers associated with sibling SAR
    // files embedded in the same EAR file, or does it have access to only
    // its own SipSessionManager?
    private boolean hasCrossSarVisibility = false;

    /**
     * Constructor.
     */
    public SipSessionsUtilImpl(ConvergedContextImpl ctx) {
        this(ctx, false);
    }

    /**
     * Constructor.
     */
    public SipSessionsUtilImpl(ConvergedContextImpl ctx,
                               boolean hasCrossSarVisibility) {
        this.ctx = ctx;
        this.hasCrossSarVisibility = hasCrossSarVisibility;
    }

    /**
     * Gets the SipApplicationSession with the given id.
     *
     * @param sasId The id of the requested SipApplicationSession
     *
     * @return The SipApplicationSession with the given id, or null if no
     * such SipApplicationSession exists
     */
    public SipApplicationSession getApplicationSession(String sasId) {
        if (sasId == null || !SipApplicationSessionUtil.isLocal(sasId)) {
            return null;
        }

        SipApplicationSessionBase sas = null;
        if (hasCrossSarVisibility) {
            Set siblings = ctx.getSiblingContexts();
            if (siblings != null) {
                Iterator iter = siblings.iterator();
                while (sas == null && iter.hasNext()) {
                    ConvergedContext cc = (ConvergedContext) iter.next();
                    SipSessionManager manager = cc.getSipSessionManager();
                    if (manager != null) {
                        try {
                            sas = manager.findSipApplicationSession(sasId);
                        } catch (RemoteLockException e) {
                            throw new RemoteLockRuntimeException(e);
                        }
                    }
                }
            }
        } else {
            SipSessionManager manager = ctx.getSipSessionManager();
            if (manager != null) {
                try {
                    sas = manager.findSipApplicationSession(sasId);
                } catch (RemoteLockException e) {
                    throw new RemoteLockRuntimeException(e);
                }
            }
        }
        if (sas != null && !sas.isValid()) sas = null;
        return sas;
    }

    public void linkSession(Object key, String applicationSessionId) {
        linkedSessions.put(key, applicationSessionId);
    }

    public SipApplicationSession getLinkedSession(Object key) {
        return getApplicationSession(linkedSessions.get(key));
    }

    public void removeSessionsMapping(SipApplicationSessionImpl sas) {
        // TODO make a more preforment delete from linked sessions and not
        // a scan.
        Iterator<String> i = linkedSessions.values().iterator();

        while (i.hasNext()) {
            if (sas.getId().equals(i.next())) {
                i.remove();

                break;
            }
        }
    }
}
