/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;

import javax.servlet.sip.URI;


/**
 * @author epetstr
 * The purpose of this class is to Internally be able to handle
 * SipURI and TelUrl the same (when applicable)
 */
public abstract class URIImpl implements URI {
    public static final String LOOSE_ROUTE_PARAM = "lr";
    public static final String FRAGID_PARAM = "fid";
    public static final String BEKEY_PARAM = "bekey";
    public static final String SASID_PARAM = "sailfinsasid";

    private static final Logger _logger = LogUtil.SIP_LOGGER.getLogger();
    protected ParameterByteMap _parameters = new ParameterByteMap(';');

    public URIImpl() {
    }

    public String getParameter(String param) {
        if (_parameters == null) {
            return null;
        }

        return _parameters.get(param);
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.sip.SipURI#getLrParam()
     */
    public boolean getLrParam() {
        String v = getParameter(LOOSE_ROUTE_PARAM);

        return (v != null) && (v.equals("") || v.equals("on") || v.equals("true"));

        // FIXME ... special case of iptel proxy router.
        // Should we support it really?
        // See newsgroup thread. 
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.sip.URI#getScheme()
     */
    public String getScheme() {
        throw new RuntimeException("Should be implemented by subclasses");
    }

    public void setParameter(String name, String value) {
        if (_parameters == null) {
            _parameters = new ParameterByteMap(';');
        }

        _parameters.put(name, value);
    }

    public void removeParameter(String name) {
        if (_parameters != null) {
            _parameters.remove(name);
        }
    }

    public Iterator<String> getParameterNames() {
        if (_parameters == null) {
            return Collections.EMPTY_LIST.iterator();
        }

        return _parameters.getKeys();
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.sip.URI#isSipURI()
     */
    public boolean isSipURI() {
        return true;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#clone()
     */
    public Object clone() {
        throw new RuntimeException("Should be implemented by subclasses");
    }

    public String getFragmentId() {
        String id = getParameter(FRAGID_PARAM);

        if (id == null) {
            return DialogFragment.DEFAULT_FRAGMENT_ID;
        } else {
            return id;
        }
    }
}
