/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import java.io.UnsupportedEncodingException;

import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;


/**
 * This is is a utility for accessing common parts in URI subclasses, that are
 * not specified in the URI interface.
 */
public class UriUtil {
    /**
     * Sets the specified parameter of the URI in the request to the specified
     * value.
     *
     * @param uri
     *                the URI
     * @param name
     *                parameter name
     * @param value
     *                parameter value
     */
    public static void setParameter(URI uri, String name, String value) {
        if (uri instanceof SipURI) {
            SipURI sipUri = (SipURI) uri;
            sipUri.setParameter(name, value);
        } else {
            TelURLImpl telUrl = (TelURLImpl) uri;
            telUrl.setParameter(name, value);
        }
    }

    /**
     * Remove the specified parameter of the URI in the request.
     *
     * @param uri
     *                the URI
     * @param name
     *           the parameter name
     * @return the value of the removed parameter (or null if parameter does not
     *         exist)
     */
    public static String removeParameter(URI uri, String name) {
        if (uri instanceof SipURI) {
            SipURI sipUri = (SipURI) uri;
            String value = sipUri.getParameter(name);
            sipUri.removeParameter(name);

            return value;
        } else {
            TelURLImpl telUrl = (TelURLImpl) uri;
            String value = telUrl.getParameter(name);
            telUrl.removeParameter(name);

            return value;
        }
    }

    /**
     * Gets the value of the specified parameter of the URI in the request.
     *
     * @param uri
     *                the URI
     * @param name
     *           parameter name
     */
    public static String getParameter(URI uri, String name) {
        if (uri instanceof SipURI) {
            SipURI sipUri = (SipURI) uri;

            return sipUri.getParameter(name);
        } else {
            TelURLImpl telUrl = (TelURLImpl) uri;

            return telUrl.getParameter(name);
        }
    }
    
    /**
     * Sets the specified parameter but encodes first using {@link SipURIEncoder#encodeParameter(String)}
     * @param uri
     * @param name
     * @param value
     */
    public static void setAndEncodeParameter(URI uri, String name, String value) {
        String encoded = null;
        if (value != null) {
            encoded = new SipURIEncoder().encodeParameter(value);
        }
        setParameter(uri, name, encoded);
    }
    
    /**
     * Gets, but first decodes (using {@link SipURIDecoder#decodeParameter(String)}) the specified parameter. 
     * @param uri
     * @param name
     * @return the decoded parameter
     * @throws UnsupportedEncodingException in case value was not possible to decode
     */
    public static String getAndDecodeParameter(URI uri, String name) throws UnsupportedEncodingException {
        String encoded = getParameter(uri, name);
        if (encoded == null) return null;
        return new SipURIDecoder().decode(encoded);
    }
}
