/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip.dns;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;


public class TargetTuple implements Externalizable {
    /**
     *
     */
    private static final long serialVersionUID = 3257289110686283316L;
    private static final int UNDEFINED_PORTNO = -1;
    private String myIp;
    private int myPort;
    private SipTransports myProtocol;

    public TargetTuple() {
    }

    public TargetTuple(SipTransports transportProtocol,
        InetSocketAddress socketAddress) {
        myProtocol = transportProtocol;
        myIp = socketAddress.getAddress().getHostAddress();
        myPort = socketAddress.getPort();
    }

    public TargetTuple(SipTransports transportProtocol, String ip, int port) {
        myProtocol = transportProtocol;
        myIp = ip;
        myPort = port;
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF(myIp);
        output.writeInt(myPort);
        output.writeObject(myProtocol);
    }

    public void readExternal(ObjectInput input) throws IOException {
        myIp = input.readUTF();
        myPort = input.readInt();

        try {
            myProtocol = (SipTransports) input.readObject();
        } catch (ClassNotFoundException ignore) {
        }
    }

    public String getIP() {
        return myIp;
    }

    public InetSocketAddress getSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(myIp), myPort);
        } catch (UnknownHostException ignored) {
        }

        return null;
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(myIp);
        } catch (UnknownHostException ignored) {
        }

        return null;
    }

    public int getPort() {
        return myPort;
    }

    public SipTransports getProtocol() {
        return myProtocol;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object org) {
        if (!(org instanceof TargetTuple)) {
            return false;
        }

        TargetTuple tt = (TargetTuple) org;

        if (myPort != tt.myPort) {
            return false;
        }

        if ((myIp != null) && !myIp.equals(tt.myIp)) {
            return false;
        }

        if ((myProtocol != null) && !myProtocol.equals(tt.myProtocol)) {
            return false;
        }

        return true;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return myIp.hashCode() ^ myPort;
    }

    public String key() {
        return myProtocol.name() + ":" + myIp + ":" + myPort;
    }

    public String toString() {
        String protocolString = myProtocol.name();

        return " ip:" + myIp + 
               " port:" + myPort + 
               " transportProtocol:" + protocolString; 
    }
}
