/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.util.os;

import sun.management.ManagementFactory;

import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;

import org.jvnet.glassfish.comms.util.LogUtil;

/**
 * Sun Microsystems' platform extensions for supporting operating system calls
 * in java.
 * 
 * @author ehsroha
 * @since 2006-mar-31
 */
/**
 * @author elnevdv
 *
 */
/**
 * @author elnevdv
 *
 */
public class OSUtilSunspecific implements OSUtil {
    private static final Logger LOGGER = LogUtil.SIP_LOGGER.getLogger();
    private com.sun.management.OperatingSystemMXBean _mxbean = (com.sun.management.OperatingSystemMXBean) ManagementFactory
            .getOperatingSystemMXBean();
    private boolean _noPlatformSupport = false;
    private long _lastTime = 0;
    private long _lastProcessCpuTime = 0;
    private int _savedBusy = 0;

    private List<MemoryPoolMXBean> _memoryPoolMbeans = ManagementFactory
            .getMemoryPoolMXBeans();
    private MemoryPoolMXBean _memoryBean = null;
    private int _savedUsage;

    public OSUtilSunspecific() {
        _lastTime = System.currentTimeMillis();
        _lastProcessCpuTime = _mxbean.getProcessCpuTime();
        _lastTime = System.currentTimeMillis();

        if (_lastProcessCpuTime == -1) {
            LOGGER
                    .warning("No platform support for com.sun.management.OperatingSystemMXBean.getProcessCpuTime()");
            // unfortunately no support on this platform...
            _noPlatformSupport = true;
        }

        for (MemoryPoolMXBean poolMbean : ManagementFactory
                .getMemoryPoolMXBeans()) {
            // PoolMBean is named "Tenured Gen" if GC options is not set
            // PoolMBean is named "CMS Old Gen" if GC options is set
            if ((poolMbean.getName().equals("Tenured Gen"))
                    || (poolMbean.getName().equals("CMS Old Gen"))) {
                _memoryBean = poolMbean;
            }
        }

    }

    public String getInfo() {
        return getClass().getName()
                + " : Sun Microsystems' platform extensions";
    }

    /**
     * Get the Sun-specific attribute Process CPU time. Returns the cpu
     * utilization as an int. If this feature is not supported by the current
     * platform 0 is always returned.
     * 
     * @return the cpu utilization as an int.
     */
    public int cpuBusy() {
        if (_noPlatformSupport) {
            return 0;
        }

        long now = System.currentTimeMillis();

        if ((now - _lastTime) > 1000) {
            // Returns the CPU time used by the process on which the Java
            // virtual
            // machine is running in nanoseconds. The returned value is of
            // nanoseconds precision but not necessarily nanoseconds accuracy.
            // This
            // method returns -1 if the the platform does not support this
            // operation.
            long currentProcessCpuTime = _mxbean.getProcessCpuTime();
            double busyPercent = (100 * (currentProcessCpuTime - _lastProcessCpuTime))
                    / (1000000 * (now - _lastTime));
            // save for next access.
            _lastTime = now;
            _lastProcessCpuTime = currentProcessCpuTime;
            _savedBusy = new Double(busyPercent).intValue();

            return _savedBusy;
        } else {
            return _savedBusy;
        }
    }

    /* (non-Javadoc)
     * @see com.ericsson.util.os.OSUtil#memUsage()
     */
    public int memUsage() {
        if (_memoryBean == null) {
            return 0;
        }
        long now = System.currentTimeMillis();
        if ((now - _lastTime) > 1000) {
            MemoryUsage usage = _memoryBean.getUsage();
            _savedUsage = (int) (((float) usage.getUsed() / usage
                    .getCommitted()) * 100);
            _lastTime = now;
        }
        return _savedUsage;
    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        OSUtilSunspecific osutil = new OSUtilSunspecific();
        Thread t = new Thread(new Runnable() {
            public long fib(int n) {
                if (n <= 1) {
                    return n;
                } else {
                    return fib(n - 1) + fib(n - 2);
                }
            }

            public void run() {
                int N = 35;

                for (int i = 1; i <= N; i++) {
                    fib(N);
                }
            }
        });
        t.start();

        for (int i = 0; i < 10; i++) {
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            System.out.println("cpuBusy = " + osutil.cpuBusy());
        }
    }

}
