/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.eas.telurl;

import java.io.IOException;

import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.URI;


/**
 * The purpose of this interface is for applications to retrieve TelURL mappings from dns.
 * The interface is implemented by the EAS SIP Container and is made
 * available for applications through a ServletContext attribute via the
 * string identifier CONTEXT_ATTRIBUTE_NAME.
 *
 * @since EAS 3.1
 */
public interface TelUrlResolver {
    /**
     * The identifier to be used when the TelUrlResolver interface is retrieved from the ServletContext.
     */
    public final String CONTEXT_ATTRIBUTE_NAME = "TelUrlResolver";

    /**
     * This method is used to retrieve the SipURI which is the result of applying TelUrl dns lookup procedure.
     * The lookup procedure is described in rfc3761 and its references.
     * @param uri
     *        The URI object representing the telephone number to be retrieved in dns. It should either be a TelUrl object or a SipURI with user=phone parameter.
     * @return The corresponding SipURI found in after applying the dns lookup procedure. Null is returned if no mapping exists.
     * @throws IOException If the dns server is not available for dns (e.g. the lookup is timed out)
     * @throws TelUrlResolverException <ul><li>
     *  If there is a loop detected when applying the lookup procedure using the matching dns server resource records.
     * </li><li>
     * The uri given as argument to this method does not represent a telephone number.
     * </li><li>
     * The uri given as argument to this method represents a local telephone number.
     * </li><li>
     * Other problems with dns resource records.
     *</li></ul>
     */
    public SipURI lookupSipURI(URI uri)
        throws IOException, TelUrlResolverException;

    /**
     * This method checks whether a given URI parameter is valid to be used for TelUrl dns lookup.
     * @param uri
     *        The URI object to be checked if it represents a telephone number.
     * @return true if URI is a TelURL or a SipURI with user=phone parameter.
     *
     */
    boolean isTelephoneNumber(URI uri);
}
