/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import javax.servlet.ServletException;


public class Rel100Exception extends ServletException {
    private static final long serialVersionUID = -7044942948132411005L;
    public static final int NOT_1XX = 0;
    public static final int NOT_INVITE = 1;
    public static final int NO_UAC_SUPPORT = 2;
    public static final int NOT_SUPPORTED = 3;
    private int _reason;

    public Rel100Exception(int reason) {
        _reason = reason;
    }

    public int getReason() {
        return _reason;
    }

    public String getMessage() {
        switch (_reason) {
        case 0:
            return "Response not a non-100 1xx";

        case 1:
            return "Response is not for an INVITE";

        case 2:
            return "The UAC didn't indicate support for 100rel in the request";

        case 3:
            return "100rel not supported by the container";
        }

        return "Failed to send response reliably";
    }
}
