/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;


/**
 * This interface class specifies the API between the container and the
 * application router.
 *
 */
public interface SipApplicationRouter {
	void init();
	
    void init(List<String> applications);

    void destroy();

    void applicationDeployed(List<String> applicationNames);

    void applicationUndeployed(List<String> applicationNames);

    /**
     * This method is called by the container when a servlet sends or proxies an
     * initial SipServletRequest. The application router returns a set of
     * information. See the documentation of SipApplicationRouterInfo class for
     * details.
     *
     * @param initialRequest
     *           The initial request for which the container is asking for 
     *           application selection. The request must not be modified by the
     *           AR. It is recommended that the implementations explicitly 
     *           disallow any mutation action by throwing appropriate 
     *           RuntimeException like IllegalStateException.
     * @param region
     *           Which region the application selection process is in.
     * @param directive
     *           The routing directive used in creating this request. If this is
     *           a request received externally, directive is NEW.
     * @param stateInfo
     *           If this request is relayed from a previous request by an
     *           application, this is the stored state the application router
     *           returned earlier when invoked to handle the previous request.
     * @return Application selection result
     */
    SipApplicationRouterInfo getNextApplication(
        SipServletReadOnlyRequest initialRequest, 
        SipApplicationRoutingRegion region,
        SipApplicationRoutingDirective directive, 
        Serializable stateInfo);
}
