/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.net.URL;

import java.util.Collection;
import java.util.Iterator;


public interface SipApplicationSession {
    long getCreationTime();

    long getLastAccessedTime();

    String getId();

    int setExpires(int expires);

    void invalidate();

    boolean isValid();

    Iterator<?> getSessions();

    Iterator<?> getSessions(String protocol);

    SipSession getSipSession(String id);

    void encodeURI(URI uri);

    Object getAttribute(String name);

    Iterator<String> getAttributeNames();

    void setAttribute(String name, Object value);

    void removeAttribute(String name);

    Collection<ServletTimer> getTimers();

    URL encodeURL(URL url);

    long getExpirationTime();

    //Introduced after EDR
    // String getApplicationName();  
    //ServletTimer getTimer(String id);
}
