/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

public interface SipFactory {
    URI createURI(String s) throws ServletParseException;

    SipURI createSipURI(String user, String host);

    Address createAddress(String sipAddress) throws ServletParseException;

    Address createAddress(URI uri);

    Address createAddress(URI uri, String displayName);

    SipServletRequest createRequest(SipApplicationSession sipAppSession,
        String method, Address from, Address to);

    SipServletRequest createRequest(SipApplicationSession sipAppSession,
        String method, URI from, URI to);

    SipServletRequest createRequest(SipApplicationSession sipAppSession,
        String method, String from, String to) throws ServletParseException;

    SipServletRequest createRequest(SipServletRequest origRequest,
        boolean sameCallId);

    SipApplicationSession createApplicationSession();

    Parameterable createParameterable(String s);

    AuthInfo createAuthInfo();
    
    SipApplicationSession createApplicationSessionByAppName(java.lang.String sipAppName);
    
    SipApplicationSession createApplicationSessionByKey(java.lang.String sipApplicationKey);
}
