/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.io.Serializable;

import java.util.Enumeration;

import javax.servlet.ServletException;


public interface SipSession extends Serializable {
    long getCreationTime();

    String getId();

    long getLastAccessedTime();

    void invalidate();

    SipApplicationSession getApplicationSession();

    String getCallId();

    Address getLocalParty();

    Address getRemoteParty();

    SipSession.State getState();

    SipServletRequest createRequest(String method);

    void setHandler(String name) throws ServletException;

    Object getAttribute(String name);

    Enumeration<String> getAttributeNames();

    void setAttribute(String name, Object value);

    void removeAttribute(String name);

    //JSR 289
    /**
     * This method allows the application to obtain the region that the application
     * is in with respect to this SipSession.  It indicates where the subscriber whom the
     * application is invoked to serve is.  If region is ORIGINATING, the subscriber is the caller.
     * If region is TERMINATING, the subscriber is the callee.
     * <p>
     * If this SipSession is created when this servlet receives an initial request,
     * this method returns the region in which this servlet is invoked.
     * <p>
     * If this SipSession is created by this servlet, the region depends on
     * the routing directive used when creating the outgoing intial request.
     * If NEW directive is used, region is ORIGINATING.  If CONTINUE directive is used to proxy
     * or relay an origRequest,
     * the region is the same as that of the SipSession of origRequest.  If
     * REVERSE directive is used to relay an origRequest, the region is the opposite of that of the SipSession of origRequest.
     * @return The routing region (ORIGINATING or TERMINATING)
     */

    //public SipApplicationRoutingRegion getRegion();
    // Change the below singature to above with the approuter changes
    String getRegion();

    /**
     * Returns the URI of the subscriber for which this application
     * is invoked to serve.  This is only available if this SipSession
     * received an initial request.  Otherwise, this method throws IllegalStateException.
     * @return URI of the subscriber
     * @throws IllegalStateException
     */
    javax.servlet.sip.URI getSubscriberURI() throws IllegalStateException;

    boolean isValid();

    boolean isOngoingTransaction();

    void setOutboundInterface(SipURI uri);
    public enum State {INITIAL,
        EARLY,
        CONFIRMED,
        TERMINATED;
    }
}
