/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.netbeans.sip.module;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.FrameworkConfigurationPanel;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Ludovic Champenois
 *
 */
public class SIPProvider extends WebFrameworkProvider {

    protected String libname = "siplibrary";            // NOI18N

    /** Creates a new instance of LibraryProvider */
    public SIPProvider() {
        super(NbBundle.getMessage(SIPProvider.class, "sip_Name"),               // NOI18N 
                NbBundle.getMessage(SIPProvider.class, "sip_Description"));     //NOI18N
    }

    public SIPProvider(String n, String d) {
        super(n, d);
    }

    public Set extend(WebModule wm) {
        Set retVal = new HashSet();
        final FileObject documentBase = wm.getDocumentBase();
        Project project = FileOwnerQuery.getOwner(documentBase);

        Library sipLibrary = LibraryManager.getDefault().getLibrary(libname);
        Sources s = project.getLookup().lookup(Sources.class);
        SourceGroup[] sources = null;
        if (null != s) {
            sources = s.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
        }
        if (sipLibrary != null) {
            Library[] sipLibs = new Library[1];
            sipLibs[0] = sipLibrary;
            boolean extended = false;
            if (sources != null && sources.length > 0) {
                try {
                    ProjectClassPathModifier.addLibraries(sipLibs, 
                            sources[0].getRootFolder(), ClassPath.COMPILE);
                    extended = true;
                } catch (IOException ioe) {
                    Logger.getLogger(SIPProvider.class.getName()).log(Level.FINER,
                            null, ioe);
                } catch (UnsupportedOperationException uoe) {
                    Logger.getLogger(SIPProvider.class.getName()).log(Level.FINER,
                            null, uoe);
                }
            }
            if (extended) {
                try {
                    FileSystem fs = wm.getWebInf().getFileSystem();
                    fs.runAtomicAction(new CreateSIPConfig(wm));
                    retVal.add(wm.getWebInf().getFileObject("sip.xml"));        // NOI18N
                } catch (FileNotFoundException exc) {
                    Logger.getLogger(SIPProvider.class.getName()).log(Level.FINER,
                            null, exc);
                } catch (IOException exc) {
                    Logger.getLogger(SIPProvider.class.getName()).log(Level.FINER,
                            null, exc);
                }
            }
        }
        return retVal;
    }

    public File[] getConfigurationFiles(WebModule wm) {
        FileObject sip = wm.getWebInf().getFileObject("sip.xml");       //NOI18N
        if (null != sip) {
            File[] configFiles = new File[1];
            configFiles[0] = FileUtil.toFile(sip);
            return configFiles;
        } else {
            return new File[0];
        }
    }

    public FrameworkConfigurationPanel getConfigurationPanel(WebModule wm) {
        return new MyFrameworkConfigurationPanel();
    }
    
    static class MyFrameworkConfigurationPanel implements FrameworkConfigurationPanel    {

            public void enableComponents(boolean enable) {
            }

            public Component getComponent() {

                return new JPanelSIP();
            }

            public HelpCtx getHelp() {

                return HelpCtx.DEFAULT_HELP;
            }

            public void readSettings(Object settings) {
            }

            public void storeSettings(Object settings) {
            }

            public boolean isValid() {

                return true;
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }
    }

    public boolean isInWebModule(org.netbeans.modules.web.api.webmodule.WebModule wm) {
        FileObject webInf = wm.getWebInf();
        return webInf == null ? false : 
            webInf.getFileObject("sip.xml") != null;            // NOI18N
        
//        final FileObject documentBase = wm.getDocumentBase();
//        Project project = FileOwnerQuery.getOwner(documentBase);
//
//        Library sipLibrary = LibraryManager.getDefault().getLibrary(libname);
//        if (null == sipLibrary) {
//            Logger.getLogger(SIPProvider.class.getName()).finest("The SIP library isn't registered???");
//            return false;
//        }
//        Sources s = project.getLookup().lookup(Sources.class);
//        if (null == s) {
//            Logger.getLogger(SIPProvider.class.getName()).finest("The WM has no sources????");
//            return false;
//        }
//        SourceGroup[] sources = s.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
//        //if (sipLibrary != null) {
//        Library[] sipLibs = new Library[1];
//        sipLibs[0] = sipLibrary;
//        boolean extended = false;
//        if (sources != null && sources.length > 0) {
//            try {
//                extended = ProjectClassPathModifier.addLibraries(sipLibs, sources[0].getRootFolder(), ClassPath.COMPILE);
//                if (extended) {
//                    ProjectClassPathModifier.removeLibraries(sipLibs, sources[0].getRootFolder(), ClassPath.COMPILE);
//                }
//                //return !extended;
//            } catch (IOException ioe) {
//                Logger.getLogger(SIPProvider.class.getName()).log(Level.FINER, null, ioe);
//            } catch (UnsupportedOperationException uoe) {
//                Logger.getLogger(SIPProvider.class.getName()).log(Level.FINER, null, uoe);
//            }
//        }
//        //}
//        return extended;
    }

    @Override
    public String getServletPath(FileObject file) {

        String url = null;

        if (file == null) {
            return url;
        }
        WebModule wm = WebModule.getWebModule(file);

        if (wm != null) {

            url = FileUtil.getRelativePath(wm.getDocumentBase(), file);

            if (url.charAt(0) != '/') {

                url = "/" + url;        // NOI18N
            }
        }

        return url;
    }

    private class CreateSIPConfig implements FileSystem.AtomicAction {

        WebModule wm;

        public CreateSIPConfig(WebModule wm) {
            this.wm = wm;
        }

        public void run() throws IOException {
            if (canCreateNewFile(wm.getWebInf(), "sip.xml")) {                  // NOI18N
                File f = new File(FileUtil.toFile(wm.getWebInf()), "sip.xml");  // NOI18N

                ConfigProvider cp = new ConfigProvider();

                cp.save(f);
            }
        }
    }

    private boolean canCreateNewFile(FileObject parent, String name) {
        File f = new File(FileUtil.toFile(parent), name);

        boolean create = true;

        if (f.exists()) {
            DialogDescriptor dialog = new DialogDescriptor
            (NbBundle.getMessage(SIPProvider.class, "MSG_OverwriteFile",        // NOI18N
                    f.getAbsolutePath()), NbBundle.getMessage(SIPProvider.class,
                    "TTL_OverwriteFile"), true, DialogDescriptor.YES_NO_OPTION, // NOI18N
                    DialogDescriptor.NO_OPTION, null);
            java.awt.Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
            d.setVisible(true);
            create = (dialog.getValue() == org.openide.DialogDescriptor.NO_OPTION);
        }

        return create;
    }
}
