/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
* Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
*/

package org.jvnet.glassfish.comms.netbeans.sip.module;

import java.io.IOException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.spi.webmodule.WebPrivilegedTemplates;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/**
 *
 * @author vkraemer
 */
public class SIPTemplates implements WebPrivilegedTemplates {
    
    /** Creates a new instance of SIPTemplates */
    public SIPTemplates() {
    }
    
    private String[] EMPTY = new String[0];
    
    static private SIPProvider sp = new SIPProvider();
    
    /**
     * Returns the list of templates which should be added in the initial 
     * "privileged" list for the project.
     *
     * @param  webModule the web module to return the templates for.
     *
     * @return full paths to privileged templates, e.g. <samp>Templates/Other/XmlFile.xml</samp>; never null.
     */
    public String[] getPrivilegedTemplates(WebModule mod) {
        FileObject fo = mod.getWebInf();
        Project proj = FileOwnerQuery.getOwner(fo);
        
        if (sp.isInWebModule(mod)) {  // NOI18N
            try {
                BuildExtension.copyTemplate(proj);
                BuildExtension.extendBuildXml(proj, "-pre-dist"); // NOI18N
            } catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            } finally {
                
            }
            return new String[] { 
                "Templates/SIP_Servlet/SipServlet.java",        // NOI18N
                "Templates/SIP_Servlet/SipListener.java",       // NOI18N
            };
        } else {
            try {
                BuildExtension.abbreviateBuildXml(proj, "-pre-dist");
                BuildExtension.removeTemplate(proj);
            } catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            } finally {
                
            }
        }
        return EMPTY;
    }
}
