/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.netbeans.sip.module.wizards;

import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

class ProjectWizardsSettings  {
    private static final ProjectWizardsSettings INSTANCE = 
            new ProjectWizardsSettings();
    private static final String NEW_PROJECT_COUNT = "newProjectCount"; //NOI18N

    String displayName() {
        return NbBundle.getMessage (ProjectWizardsSettings.class, 
                "TXT_SIPProjectFolderList"); //NOI18N
    }
    
    private static Preferences getPreferences() {
        return NbPreferences.forModule(ProjectWizardsSettings.class);
    }

    int getNewProjectCount () {
        return getPreferences().getInt(NEW_PROJECT_COUNT, 0);
    }

    void setNewProjectCount (int count) {
        getPreferences().putInt(NEW_PROJECT_COUNT, count);
    }
    
    static ProjectWizardsSettings getDefault () {
        return INSTANCE;
    }
}
