/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.netbeans.sip.module.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public final class SipListenerVisualPanel1 extends JPanel {

    /** Creates new form SipListenerVisualPanel1 */
    public SipListenerVisualPanel1(SipListenerWizardPanel1 model) {
        initComponents();
        listOfBoxes = new javax.swing.JCheckBox[]{
            implSipAppSess, implSipAppSessAct, implSipAppSessAttr,
            implSipAppSessBind, implSipError, implSipServlet, implSipSess,
            implSipSessAct, implSipSessAttr, implSipSessBind, implTimerListener };
        Listener l = new Listener(model);
        implSipAppSess.addActionListener(l);
        implSipAppSessAct.addActionListener(l);
        implSipAppSessAttr.addActionListener(l);
        implSipAppSessBind.addActionListener(l);
        implSipError.addActionListener(l);
        implSipServlet.addActionListener(l);
        implSipSess.addActionListener(l);
        implSipSessAct.addActionListener(l);
        implSipSessAttr.addActionListener(l);
        implSipSessBind.addActionListener(l);
        implTimerListener.addActionListener(l);
    }

    @Override
    public String getName() {
        return "Step #1";
    }

    String[] getInterfaces() {
        int len = 0;
        for (javax.swing.JCheckBox box : listOfBoxes) {
            if (null != box && box.isSelected()) 
                len++;
        }
        String[] retVal = new String[len];
        if (len > 0) {
            int dex = 0;        
            for (javax.swing.JCheckBox box : listOfBoxes) {
                if (box.isSelected()) {
                    retVal[dex] = "javax.servlet.sip."+box.getName();
                    dex++;
                }
            }
            
        }
        return retVal;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        headerLabel = new javax.swing.JLabel();
        panelSipApp = new javax.swing.JPanel();
        implSipAppSessAct = new javax.swing.JCheckBox();
        implSipAppSessAttr = new javax.swing.JCheckBox();
        implSipAppSessBind = new javax.swing.JCheckBox();
        implSipAppSess = new javax.swing.JCheckBox();
        implSipError = new javax.swing.JCheckBox();
        implSipServlet = new javax.swing.JCheckBox();
        panelSipSess = new javax.swing.JPanel();
        implSipSessAct = new javax.swing.JCheckBox();
        implSipSessAttr = new javax.swing.JCheckBox();
        implSipSessBind = new javax.swing.JCheckBox();
        implSipSess = new javax.swing.JCheckBox();
        implTimerListener = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();

        org.openide.awt.Mnemonics.setLocalizedText(headerLabel, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_LISTENER_WIZARD_PANEL_HEADER")); // NOI18N

        panelSipApp.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_sipAppPanel"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipAppSessAct, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipAppSessAct")); // NOI18N
        implSipAppSessAct.setName("SipApplicationSessionActivationListener"); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipAppSessAttr, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipAppSessAttr")); // NOI18N
        implSipAppSessAttr.setName("SipApplicationSessionAttributeListener"); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipAppSessBind, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipAppSessBind")); // NOI18N
        implSipAppSessBind.setName("SipApplicationSessionBindingListener"); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipAppSess, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipAppSess")); // NOI18N
        implSipAppSess.setName("SipApplicationSessionListener"); // NOI18N

        org.jdesktop.layout.GroupLayout panelSipAppLayout = new org.jdesktop.layout.GroupLayout(panelSipApp);
        panelSipApp.setLayout(panelSipAppLayout);
        panelSipAppLayout.setHorizontalGroup(
            panelSipAppLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelSipAppLayout.createSequentialGroup()
                .addContainerGap()
                .add(panelSipAppLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(implSipAppSessAct)
                    .add(implSipAppSessAttr)
                    .add(implSipAppSessBind)
                    .add(implSipAppSess))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        panelSipAppLayout.setVerticalGroup(
            panelSipAppLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelSipAppLayout.createSequentialGroup()
                .add(implSipAppSessAct)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(implSipAppSessAttr)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(implSipAppSessBind)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(implSipAppSess))
        );

        org.openide.awt.Mnemonics.setLocalizedText(implSipError, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipError")); // NOI18N
        implSipError.setName("SipErrorListener"); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipServlet, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipServlet")); // NOI18N
        implSipServlet.setName("SipServletListener"); // NOI18N

        panelSipSess.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_panelSipSess"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipSessAct, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipSessAct")); // NOI18N
        implSipSessAct.setName("SipSessionActivationListener"); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipSessAttr, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipSessAttr")); // NOI18N
        implSipSessAttr.setName("SipSessionAttributeListener"); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipSessBind, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipSessBind")); // NOI18N
        implSipSessBind.setName("SipSessionBindingListener"); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(implSipSess, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implSipSess")); // NOI18N
        implSipSess.setName("SipSessionListener"); // NOI18N

        org.jdesktop.layout.GroupLayout panelSipSessLayout = new org.jdesktop.layout.GroupLayout(panelSipSess);
        panelSipSess.setLayout(panelSipSessLayout);
        panelSipSessLayout.setHorizontalGroup(
            panelSipSessLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelSipSessLayout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(panelSipSessLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(implSipSessAct)
                    .add(implSipSessAttr)
                    .add(implSipSessBind)))
            .add(panelSipSessLayout.createSequentialGroup()
                .addContainerGap()
                .add(implSipSess)
                .addContainerGap(48, Short.MAX_VALUE))
        );
        panelSipSessLayout.setVerticalGroup(
            panelSipSessLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelSipSessLayout.createSequentialGroup()
                .add(implSipSessAct)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(implSipSessAttr)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(implSipSessBind)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(implSipSess))
        );

        org.openide.awt.Mnemonics.setLocalizedText(implTimerListener, org.openide.util.NbBundle.getMessage(SipListenerVisualPanel1.class, "LBL_implTimerListener")); // NOI18N
        implTimerListener.setName("TimerListener"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 116, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 126, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(headerLabel)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(panelSipApp, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(panelSipSess, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(layout.createSequentialGroup()
                                .add(27, 27, 27)
                                .add(implSipServlet)
                                .add(28, 28, 28)
                                .add(implSipError)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(implTimerListener)
                            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(headerLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(implSipServlet)
                    .add(implSipError)
                    .add(implTimerListener))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, panelSipSess, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, panelSipApp, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel headerLabel;
    private javax.swing.JCheckBox implSipAppSess;
    private javax.swing.JCheckBox implSipAppSessAct;
    private javax.swing.JCheckBox implSipAppSessAttr;
    private javax.swing.JCheckBox implSipAppSessBind;
    private javax.swing.JCheckBox implSipError;
    private javax.swing.JCheckBox implSipServlet;
    private javax.swing.JCheckBox implSipSess;
    private javax.swing.JCheckBox implSipSessAct;
    private javax.swing.JCheckBox implSipSessAttr;
    private javax.swing.JCheckBox implSipSessBind;
    private javax.swing.JCheckBox implTimerListener;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel panelSipApp;
    private javax.swing.JPanel panelSipSess;
    // End of variables declaration//GEN-END:variables

    private javax.swing.JCheckBox[] listOfBoxes;
    
    static class Listener implements ActionListener {
        private SipListenerWizardPanel1 m;
        
        Listener(SipListenerWizardPanel1 m) {
            this.m = m;
        }

        public void actionPerformed(ActionEvent arg0) {
            m.viewChanged();
        }
        
    }
}

