/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/**
 *
 * @author ELNYVBO
 */
public class LogSupport {
    
    /** Creates a new instance of LogSupport */
    public LogSupport(Constants aConstants) {
    }
    
    /**
     *  update logging configuration to read info from custom logfile
     */
    public static void initLogging(Constants aConstants) {
        final String fileName = 
            aConstants.getProperty(Constants.LOGGING_CONFIGURATION_FILE);
        String home = System.getProperty("user.home");
        
        try {
            File f = new File(home + File.separator + fileName);
            if (f.exists() && f.canRead()) {
                FileInputStream confStream = new FileInputStream(f);
                LogManager.getLogManager().reset();
                LogManager.getLogManager().readConfiguration(confStream); 
            }
        } catch (FileNotFoundException fnfe) {
            // this should not happen
            Logger.getLogger(LogSupport.class.getName()).log(Level.FINER,null,fnfe);
        } catch (IOException e) {
            System.out.println(
                "WARNING: Could not read logging configuration file: \n" + 
                e.getMessage() + "\n" +
                "To enable logging, place a file called " + fileName + " with" +
                " the correct permissions in your home directory.\n" +
                "The contents of the file should follow java.util.logging " +
                "conventions. For example: \n\n" +
                
                "######################################################\n" +
                "handlers=java.util.logging.FileHandler\n" +
                "java.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter\n" +
                "org.jvnet.glassfish.comms.sipagent.ui.ControllerAgent.level=ALL\n" +
                "org.jvnet.glassfish.comms.sipagent.ui.AgentMainJPanel.level=ALL\n" +
                "######################################################\n\n" +
                
                "The SIP Test Agent will now resume normal operation" +
                " without logging.\n");
        }
    }
    
    /**
     *  Utility method for converting stacktraces to Strings, which can then
     *  be appended easily to e.g. a logfile.
     */
    public static String stringify(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();   
    }
}
