/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.transport;

import org.jvnet.glassfish.comms.sipagent.support.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Logger;

/**
 *
 * Just a test class, not used in SIP test agent
 * @author elnyvbo
 * 
 */
public class Connection {
    
    private static Logger theirLogger =
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.transport.Connection");
    
   Constants itsConstants = new Constants();
   Socket itsSocket = null;
   PrintWriter itsOut = null;
   BufferedReader itsIn = null;
   
    /** Creates a new instance of Connection */
    public Connection() {
        String host = itsConstants.getProperty(Constants.HOST);
        String port = itsConstants.getProperty(Constants.PORT);
        int portNr = 5060; 
        try
        {
            portNr = Integer.parseInt(port);
        }
        catch (Exception e)
        {
            theirLogger.severe(
                "ERROR: Illegal SIP server port configured, will use 5060");
        }
        
        theirLogger.finer(
            "Connecting to host " + host + " on port " + port + "...");
        
        
        try{
            itsSocket = new Socket(host, portNr);
            theirLogger.finer("Socket created: " + itsSocket);
            itsOut = new PrintWriter(itsSocket.getOutputStream(), true);
            theirLogger.finer("Out: " + itsOut);
            itsIn = new BufferedReader(new InputStreamReader(itsSocket.getInputStream()));
            theirLogger.finer("In: " + itsIn);
        } catch (UnknownHostException e) {
            theirLogger.severe("ERROR: Unknown host " + host + ":" + portNr);
        } catch (IOException e) {
            theirLogger.severe("ERROR: No I/O: " + e);
        }
    }
    
    public void send(String aText)
    {
        theirLogger.finest("----- send() ----->");
        theirLogger.fine("Writing to " + itsSocket + ": \n" + aText);
        itsOut.write(aText);
        itsOut.flush();
        theirLogger.finest("<----- send() -----");
    }
    
}
