/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.transport;

import java.io.Closeable;
import java.io.InputStream;
import java.net.Socket;
import java.util.TimerTask;
import java.util.logging.Logger;

final class SocketRunner
        implements Runnable {
    
    private static Logger theirLogger =
        Logger.getLogger("com.ericsson.sip.sipagent.transport.SocketRunner");
    
    
    private boolean itsIsIdle;
    private Socket itsSocket;
    private TimerTask itsTimerTask;
    final TCPSocketHandler itsTcpSocketHandler;
    
    public SocketRunner(TCPSocketHandler tcpsockethandler, Socket socket) {
        super();
        itsTcpSocketHandler = tcpsockethandler;
        itsIsIdle = true;
        itsSocket = socket;
    }
    
    public final void run() {
        InputStream inputstream = null;
        itsTimerTask = new Job(this);
        TCPSocketHandler.getTimer().schedule(itsTimerTask, 60000L);
        try {
            inputstream = itsSocket.getInputStream();
            while(itsIsIdle)
                if(inputstream.available() > 0) {
                String s = TCPSocketHandler.getString(itsTcpSocketHandler, inputstream);
                itsTcpSocketHandler.fireIncomingMessage(
                        "tcp",
                        itsTcpSocketHandler.localHost.toString(),
                        itsTcpSocketHandler.localPort,
                        s);
                itsIsIdle = false;
                } else {
                try {
                    Thread.sleep(200L);
                } catch(InterruptedException _ex) { }
                }
        } catch(Throwable _ex) {
            closeCloseable(inputstream);
            closeSocket(itsSocket);
            itsSocket = null;
            itsTimerTask.cancel();
            return;
        }
        closeCloseable(inputstream);
        closeSocket(itsSocket);
        itsSocket = null;
        itsTimerTask.cancel();
    }
    
    public final void cancelTimer() {
        itsIsIdle = false;
        itsTimerTask.cancel();
    }
    
    private static void closeSocket(Socket aSocket) {
        if(aSocket != null) {
            try {
                aSocket.close();
                return;
            } catch(Exception _ex) {
                theirLogger.severe("ERROR closing socket: " + _ex);
            }}
    }
    
    private static void closeCloseable(Closeable aCloseable) {
        if(aCloseable != null) {
            try {
                aCloseable.close();
                return;
            } catch(Exception _ex) { }}
    }
    
    static boolean setIdle(SocketRunner aSocketRunner, boolean flag) {
        return aSocketRunner.itsIsIdle = flag;
    }
}
