/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.transport;

import org.jvnet.glassfish.comms.sipagent.model.SipMessage;
import java.io.*;
import java.net.*;
import java.util.Timer;

/**
 *  Subclass of the SocketHandler that handles TCP connections.
 */
public class TCPSocketHandler extends SocketHandler {
   
    public TCPSocketHandler(InetAddress inetaddress, int i, InetAddress inetaddress1, int j) {
        super(inetaddress, i, inetaddress1, j);
    }
    
    protected void closeSocket()
    throws Exception {
        if(itsServerSocket != null && !itsServerSocket.isClosed()){
            itsServerSocket.close();}
        if(itsSocketRunner != null){
            SocketRunner.setIdle(itsSocketRunner, true);}
    }

    protected void listen()
    throws Exception {
        if(itsServerSocket == null || itsServerSocket.isClosed())
            itsServerSocket = new ServerSocket(localPort);
        Socket socket;
        InputStream inputstream;
        String s = getString(inputstream = (socket = itsServerSocket.accept()).getInputStream());
        inputstream.close();
        socket.close();
        fireIncomingMessage("tcp", localHost.getHostAddress(), localPort, s);
    }
    
    private static String getString(InputStream inputstream)
    throws Exception {
        int i = 0;
        StringBuilder s = new StringBuilder();
        byte abyte0[] = new byte[1024];
        do
            if((i = inputstream.read(abyte0)) > -1)
                s.append(new String(abyte0, 0, i, "UTF-8"));
        while(inputstream.available() > 0);
        return s.toString();
    }
    
    public void sendMessage(SipMessage sipmessage)
    throws Exception {
        doSendMessage(sipmessage);
    }
    
    private void doSendMessage(SipMessage sipmessage)
    throws Exception {
        Socket socket = new Socket(remoteHost, remotePort);
        itsSocketRunner = new SocketRunner(this, socket);
        Thread t =
                new Thread(
                itsSocketRunner,
                "Read From Local Address");
        t.start();
        OutputStream outputstream;
        (outputstream = socket.getOutputStream()).write(
            sipmessage.toString().getBytes());
        outputstream.flush();
        fireOutgoingMessage(sipmessage);
    }
    
    static Timer getTimer() {
        return itsTimer;
    }
    
    static String getString(TCPSocketHandler tcpsockethandler, InputStream inputstream)
    throws Exception {
        return getString(inputstream);
    }
    
    private ServerSocket itsServerSocket;
    private SocketRunner itsSocketRunner;
    private static final Timer itsTimer = new Timer();
    
}
