/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.transport;

import org.jvnet.glassfish.comms.sipagent.model.SipMessage;
import java.io.IOException;
import java.net.*;

// Referenced classes of package com.ericsson.sds.te.testagent.transport:
//            SocketHandler

public class UDPSocketHandler extends SocketHandler
{

    public UDPSocketHandler(InetAddress inetaddress, int i, InetAddress inetaddress1, int j)
    {
        super(inetaddress, i, inetaddress1, j);
        byte abyte0[] = new byte[8192];
        a_java_net_DatagramPacket_fld = new DatagramPacket(abyte0, abyte0.length);
    }

    public void listen()
        throws Exception
    {
        if(a_java_net_DatagramSocket_fld == null || a_java_net_DatagramSocket_fld.isClosed())
            a_java_net_DatagramSocket_fld = new DatagramSocket(localPort);
        a_java_net_DatagramSocket_fld.receive(a_java_net_DatagramPacket_fld);
        String s = new String(a_java_net_DatagramPacket_fld.getData(), 0, a_java_net_DatagramPacket_fld.getLength(), "UTF-8");
        fireIncomingMessage("udp", localHost.getHostAddress(), localPort, s);
    }

    protected void closeSocket()
        throws Exception
    {
        if(a_java_net_DatagramSocket_fld != null && !a_java_net_DatagramSocket_fld.isClosed())
            a_java_net_DatagramSocket_fld.close();
    }

    public void sendMessage(SipMessage sipmessage)
        throws IOException
    {
        byte abyte0[] = sipmessage.toString().getBytes("UTF-8");
        DatagramPacket datagrampacket = new DatagramPacket(abyte0, abyte0.length, remoteHost, remotePort);
        a_java_net_DatagramSocket_fld.send(datagrampacket);
        fireOutgoingMessage(sipmessage);
    }

    private DatagramSocket a_java_net_DatagramSocket_fld;
    private DatagramPacket a_java_net_DatagramPacket_fld;
}
