/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.ui;

import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

/**
 *  Listener class for handling modifications in the headertable in the
 *  RequestEdit window.
 *
 *
 * @author elnyvbo
 */
public class HeaderTableListener implements TableModelListener{
    
    private MessageBean itsBean = null;
    private AgentMainJPanel itsPanel = null;
    
    private static Logger theirLogger =
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.ui.HeaderTableListener");
   
    /** Creates a new instance of HeaderTableListener */
    public HeaderTableListener(AgentMainJPanel aPanel, MessageBean aBean) {
        itsBean = aBean;
        itsPanel = aPanel;
    }
    
    public void setBean(MessageBean aBean){
        itsBean = aBean;
    }
    
    /**
     *  row updated -> means a header or value was modified. repopulate bean and
     *                  update screen.
     */
    public void tableChanged(TableModelEvent e) {
        theirLogger.finest("----- tableChanged() ----->");
        if (e.getType() == TableModelEvent.UPDATE){
            theirLogger.fine("Table updated at row " + e.getFirstRow()
            + ", column " + e.getColumn());
            
            // just cancel all header values and iterate through the table model
            DefaultTableModel model = ((DefaultTableModel)(e.getSource()));
            repopulate(model);
        }
        // else do nothing, table additions are handled in the main panel
        // in response to the 'Add' button.
        
        theirLogger.finest("<----- tableChanged() -----");
    }
    /**
     *  Clear all header values and refill based on the model passed in.
     */
    void repopulate(TableModel aModel){
        theirLogger.finest("----- repopulate() ----->");
        itsBean.clearHeaders();
        try {
            int rc = aModel.getRowCount();
            for (int i=0; i<rc; i++){
                itsBean.addHeaderValue(
                    (String)aModel.getValueAt(i,0), 
                    (String)aModel.getValueAt(i,1));
            }
                        
           itsPanel.updatePreviewPanel(itsBean);
        }
        catch (Throwable t){
            theirLogger.severe("ERROR: COULD NOT REPOPULATE TABLE: \n" + t);
        }
        
        theirLogger.finest("<----- repopulate() -----");
    }
}
