/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.sipagent.ui;

import java.awt.BorderLayout;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Just a wrapper class to plug the SIP Agent into NetBeans.
 *
 * @author elnyvbo
 */
public class SipAgentMainWindow extends TopComponent {
    
    AgentMainJPanel itsSipAgent = null;
    static private int sessionsCreated = 0;
    
    /** Creates a new instance of SipAgentMainWindow */
    public SipAgentMainWindow(int anInstanceNr) {
        itsSipAgent = new AgentMainJPanel(sessionsCreated);
        sessionsCreated++;
        initComponents();
        open();
    }
    
    static public SipAgentMainWindow get(String name) {
        // search and create
        TopComponent retVal = WindowManager.getDefault().findTopComponent(name);
        if (null == retVal || !(retVal instanceof SipAgentMainWindow)) {
            retVal = new SipAgentMainWindow(name);
        }
        return (SipAgentMainWindow) retVal;
    }
    
    /** Creates a new instance of SipAgentMainWindow */
    private SipAgentMainWindow(String sessionName) {
        itsSipAgent = new AgentMainJPanel(sessionsCreated);
        sessionsCreated++;
        setName(sessionName);
        initComponents();
        open();
    }
    
    public int getPersistenceType() {
        return PERSISTENCE_NEVER;
    }

    public String preferredID() {
        return "sipperdeflip";
    }
    
    private void initComponents()
    {
        setLayout(new BorderLayout());
        setDisplayName("SIP Test Agent");
        add(itsSipAgent, BorderLayout.CENTER);
    }

    protected void componentClosed() {
        itsSipAgent.cleanup();
    }

}
