/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.IOUtil;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.UriManager;
import jmaki.runtime.WidgetResourceException;
import jmaki.runtime.config.ApiKey;
import jmaki.runtime.config.Config;
import jmaki.runtime.config.ConfigUtil;
import jmaki.runtime.config.Extension;
import jmaki.runtime.config.GlobalConfig;
import jmaki.runtime.config.GlueInclude;

public class AjaxCommonRenderer {
    private AjaxContext ajx;
    private GlobalConfig globalConfig;
    private Config widgetConfig;
    private ResourceManager resourceManager;
    private UriManager uriManager;
    private Writer out;
    private String globalWebRoot;
    private String resourcesDir;
    private String name;
    private String uuid;
    private String template;
    private String style;
    private String args;
    private String script;
    private String service;
    private String value;
    private String publish;
    private String subscribe;
    private String absoluteWidgetPath;
    private Iterator libs;
    private Iterator styles;
    private boolean isWidgetWebAppResource;
    private boolean isGlobalConfigWebAppResource;
    private boolean isGlobalBootstrapScriptWebAppResource;
    private Map widgetProperties;
    private static Logger logger;

    public void setName(String name) {
        this.name = name;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setPublish(String publish) {
        this.publish = publish;
    }

    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
    }

    public AjaxCommonRenderer(AjaxContext ajx) throws AjaxException {
        this.ajx = ajx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws AjaxException {
        String tmpScript;
        this.globalConfig = this.ajx.getGlobalConfig();
        this.resourceManager = this.ajx.getResourceHandler();
        String widgetPath = this.resourceManager.getWidgetDir(this.name);
        String widgetDir = null;
        if (this.script == null) {
            this.script = "component.js";
        }
        if (this.resourceManager.isWebAppResource(tmpScript = IOUtil.resolvePath(widgetDir = this.ajx.getWorkingDir() + widgetPath, this.script))) {
            this.script = tmpScript;
            this.isWidgetWebAppResource = true;
        } else {
            widgetDir = this.resourceManager.getWebResourcePath() + widgetPath;
            tmpScript = IOUtil.resolvePath(widgetDir, this.script);
            if (this.resourceManager.isWebAppResource(tmpScript)) {
                this.script = tmpScript;
                this.isWidgetWebAppResource = true;
            } else {
                widgetDir = this.resourceManager.getResourcesDir() + widgetPath;
                tmpScript = IOUtil.resolvePath(widgetDir, this.script);
                if (!this.resourceManager.isClassPathResource(tmpScript)) throw new WidgetResourceException("unable to locate '" + this.script + "' in '" + this.ajx.getWorkingDir() + widgetPath + "', '" + this.resourceManager.getWebResourcePath() + widgetPath + "' and ClassPath 'META-INF" + this.resourceManager.getResourcesDir() + widgetPath + "'");
                this.script = tmpScript;
                this.isWidgetWebAppResource = false;
            }
        }
        this.uriManager = this.ajx.getUriManager();
        this.out = this.ajx.getWriter();
        if (this.uuid == null) {
            this.uuid = this.name + "" + this.ajx.getUniqueId();
            this.uuid = this.uuid.replace('.', '_');
        }
        this.isGlobalConfigWebAppResource = this.globalConfig.isGlobalConfigWebAppResource();
        this.isGlobalBootstrapScriptWebAppResource = this.globalConfig.isGlobalBootstrapScriptWebAppResource();
        this.resourcesDir = this.resourceManager.getResourcesDir();
        if (this.style == null) {
            String stylePath = widgetDir + "/component.css";
            if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(stylePath) : this.resourceManager.isClassPathResource(stylePath)) {
                this.style = stylePath;
            }
        } else {
            this.style = IOUtil.resolvePath(widgetDir, this.style);
        }
        if (this.template == null) {
            String templatePath = widgetDir + "/component.htm";
            if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath)) {
                this.template = templatePath;
            } else {
                templatePath = templatePath + "l";
                if (!(this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath))) throw new WidgetResourceException("Failed to locate '" + templatePath + "' in webapp an classpath for widget '" + this.name + "'");
                this.template = templatePath;
            }
        } else {
            this.template = IOUtil.resolvePath(widgetDir, this.template);
        }
        this.widgetConfig = this.globalConfig.getConfig(this.name, widgetDir);
        this.libs = this.widgetConfig.getLibs();
        this.styles = this.widgetConfig.getStyles();
        this.absoluteWidgetPath = this.isWidgetWebAppResource ? this.uriManager.buildWebAppResourceReference(this.ajx, widgetDir) : this.uriManager.buildClassPathResourceReference(this.ajx, widgetDir);
        this.globalWebRoot = this.isGlobalConfigWebAppResource ? this.uriManager.buildWebAppResourceReference(this.ajx, "") : this.uriManager.buildClassPathResourceReference(this.ajx, "");
        AjaxCommonRenderer.getLogger().finest("uuid: '" + this.uuid + "', widgettype: '" + this.name + "', globalWebRoot: '" + this.globalWebRoot + "', resourcesDir: '" + this.resourcesDir + "', widgetdir: '" + widgetDir + "', absoluteWidgetPath: '" + this.absoluteWidgetPath + "', template: '" + this.template + "', style: '" + this.style + "', script: '" + this.script + "', development-mode: '" + (this.ajx.getUseCache() ? "off'" : "on'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doProcess() throws IOException, AjaxException {
        block24: {
            try {
                String widgetId;
                this.init();
                if (!this.ajx.isBootstrapScriptWritten()) {
                    boolean devMode = ConfigUtil.isInitParameterSet(this.ajx.getContext(), "jmaki-development-mode") && ConfigUtil.getBooleanInitParameter(this.ajx.getContext(), "jmaki-development-mode");
                    String jmakiBootUri = devMode ? "/jmaki-uncompressed.js" : "/jmaki.js";
                    this.writeLib(this.buildResourceReference(this.resourcesDir + jmakiBootUri, this.isGlobalBootstrapScriptWebAppResource));
                    this.writeScript("jmaki.webRoot='" + this.ajx.getApplicationRoot() + "';" + "jmaki.resourcesRoot ='" + this.resourcesDir + "';" + "jmaki.xhp ='" + this.ajx.getApplicationRoot() + this.ajx.getXhpMapping() + "';");
                    Iterator exs = this.globalConfig.getExtensions();
                    while (exs.hasNext()) {
                        String extensionDir;
                        String extensionLib;
                        Extension ex = (Extension)exs.next();
                        if (!IOUtil.matchURL(this.ajx.getCurrentURI(), ex.getURL()) || this.ajx.isLibraryWritten(extensionLib = (extensionDir = this.buildResourceReference(this.resourceManager.getResourcesDir() + this.resourceManager.getExtensionDir(ex.getName()))) + "/extension.js")) continue;
                        this.writeLib(extensionLib);
                        String args = ex.getArgs();
                        this.writeScript("jmaki.addExtension({name : '" + ex.getName() + "', " + "extensionDir : '" + extensionDir + "'" + (args == null ? "" : ", args : " + args) + "});");
                        this.ajx.setLibraryWritten(extensionLib);
                    }
                    Iterator glueIncludes = this.globalConfig.getGlueIncludes();
                    while (glueIncludes.hasNext()) {
                        GlueInclude glueInclude = (GlueInclude)glueIncludes.next();
                        String glueIncludeLib = null;
                        if (!IOUtil.matchURL(this.ajx.getCurrentURI(), glueInclude.getURL()) || this.ajx.isLibraryWritten(glueIncludeLib = glueInclude.getLib())) continue;
                        this.writeLib(this.buildResourceReference(glueIncludeLib));
                        this.ajx.setLibraryWritten(glueIncludeLib);
                    }
                    this.ajx.setBootstrapScriptWritten(true);
                }
                if ((widgetId = this.widgetConfig.getId()) != null && !this.ajx.isTypeWritten(widgetId)) {
                    String preload = null;
                    preload = this.widgetConfig.getPreLoad();
                    if (preload != null) {
                        this.writeScript(preload);
                    }
                    while (this.libs.hasNext()) {
                        String lib = (String)this.libs.next();
                        Iterator apiKeys = this.widgetConfig.getApiKeys();
                        while (apiKeys.hasNext()) {
                            ApiKey apiKey = (ApiKey)apiKeys.next();
                            String targetURL = apiKey.getUrl();
                            if ((targetURL == null || !targetURL.equals(this.ajx.getWebRoot() + "/")) && !targetURL.equals(this.globalWebRoot + "/") && !targetURL.equals("*")) continue;
                            lib = lib + apiKey.getKey();
                            break;
                        }
                        if (this.ajx.isLibraryWritten(lib)) continue;
                        if (this.widgetConfig.isDynamicallyLoadable()) {
                            this.writeLib(this.buildResourceReference(lib));
                        } else {
                            this.writeScript("jmaki.writeScript('" + this.buildResourceReference(lib) + "', '" + this.uuid + "');");
                        }
                        this.ajx.setLibraryWritten(lib);
                    }
                    String postload = null;
                    postload = this.widgetConfig.getPostLoad();
                    if (postload != null) {
                        this.writeScript(postload);
                    }
                    while (this.styles.hasNext()) {
                        String style = (String)this.styles.next();
                        if (this.ajx.isStyleWritten(style)) continue;
                        this.writeStyle(this.buildResourceReference(style));
                        this.ajx.setStyleWritten(style);
                    }
                    this.ajx.setTypeWritten(widgetId);
                }
                if (this.style != null && !this.ajx.isStyleWritten(this.style)) {
                    this.writeStyle(this.buildResourceReference(this.style, this.isWidgetWebAppResource));
                    this.ajx.setStyleWritten(this.style);
                }
                if (!this.ajx.isLibraryWritten(this.script)) {
                    this.writeLib(this.buildResourceReference(this.script, this.isWidgetWebAppResource));
                    this.ajx.setLibraryWritten(this.script);
                }
                if (this.template != null) {
                    this.writeTemplate(this.template);
                }
                this.widgetProperties = new HashMap();
                this.widgetProperties.put("uuid", this.uuid);
                this.widgetProperties.put("name", this.name);
                this.widgetProperties.put("sourceURL", this.ajx.getSourceURL());
                this.widgetProperties.put("widgetDir", this.absoluteWidgetPath);
                if (this.publish != null) {
                    this.widgetProperties.put("publish", this.publish);
                }
                if (this.service != null) {
                    this.widgetProperties.put("service", this.service);
                }
                if (this.subscribe != null) {
                    this.widgetProperties.put("subscribe", this.subscribe);
                }
                if (this.value != null) {
                    this.widgetProperties.put("value", this.value);
                }
                if (this.args != null) {
                    this.widgetProperties.put("args", this.args);
                }
                this.writeScript("jmaki.addWidget(" + IOUtil.createJavaScriptObject(this.widgetProperties) + ");");
                Object var9_9 = null;
                if (this.widgetProperties != null) {
                    this.widgetProperties.clear();
                    this.widgetProperties = null;
                }
                if (this.ajx.getUseCache()) break block24;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (this.widgetProperties != null) {
                    this.widgetProperties.clear();
                    this.widgetProperties = null;
                }
                if (!this.ajx.getUseCache()) {
                    this.ajx.discardConfig();
                }
                this.ajx = null;
                this.widgetConfig = null;
                this.resourceManager = null;
                this.uriManager = null;
                this.out = null;
                this.libs = null;
                this.styles = null;
                this.template = null;
                this.name = null;
                this.script = null;
                this.publish = null;
                this.subscribe = null;
                throw throwable;
            }
            this.ajx.discardConfig();
        }
        this.ajx = null;
        this.widgetConfig = null;
        this.resourceManager = null;
        this.uriManager = null;
        this.out = null;
        this.libs = null;
        this.styles = null;
        this.template = null;
        this.name = null;
        this.script = null;
        this.publish = null;
        this.subscribe = null;
    }

    private void writeTemplate(String template) throws IOException {
        URL templateURL = this.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(template) : this.resourceManager.locateClassPathResource(template);
        StringBuffer templateBuffer = null;
        try {
            templateBuffer = IOUtil.loadResource(templateURL.openStream(), "UTF-8");
        }
        catch (IOException ioe) {
            throw new WidgetResourceException("failed to load 'component.htm' for widget '" + this.name + "'", ioe);
        }
        IOUtil.replace(templateBuffer, "${uuid}", this.uuid);
        if (this.service != null) {
            IOUtil.replace(templateBuffer, "${service}", this.service);
        }
        if (this.args != null) {
            IOUtil.replace(templateBuffer, "${args}", this.args);
        }
        if (this.value != null) {
            if (this.value.startsWith("@{")) {
                IOUtil.replace(templateBuffer, "${value}", "");
            } else {
                IOUtil.replace(templateBuffer, "${value}", this.value);
            }
        }
        IOUtil.replace(templateBuffer, "${webRoot}", this.globalWebRoot);
        IOUtil.replace(templateBuffer, "${widgetDir}", this.absoluteWidgetPath);
        IOUtil.replace(templateBuffer, "${contextPath}", this.ajx.getRequest().getContextPath());
        this.out.write(templateBuffer.toString());
    }

    private String buildResourceReference(String resource) throws AjaxException {
        if (IOUtil.isExternalUri(resource)) {
            return resource;
        }
        if (this.resourceManager.isWebAppResource(resource)) {
            return this.uriManager.buildWebAppResourceReference(this.ajx, resource);
        }
        if (this.resourceManager.isClassPathResource(resource)) {
            return this.uriManager.buildClassPathResourceReference(this.ajx, resource);
        }
        if (this.ajx.isStrictCheckingMode()) {
            throw new WidgetResourceException("Unable to locate resource '" + resource + "' in webapp or classpath");
        }
        AjaxCommonRenderer.getLogger().warning("Unable to locate resource in webapp or classpath, using the unverified and unaltered Uri: '" + resource + "'");
        return resource;
    }

    private String buildResourceReference(String resource, boolean isWebAppResource) throws AjaxException {
        if (IOUtil.isExternalUri(resource)) {
            return resource;
        }
        return isWebAppResource ? this.uriManager.buildWebAppResourceReference(this.ajx, resource) : this.uriManager.buildClassPathResourceReference(this.ajx, resource);
    }

    private void writeScript(String script) throws IOException {
        this.out.write("<script type=\"text/javascript\">" + script + "</script>\n");
    }

    private void writeLib(String lib) throws IOException {
        this.out.write("<script type=\"text/javascript\" src=\"" + lib + "\"></script>\n");
    }

    private void writeStyle(String style) throws IOException {
        this.out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + style + "\"></link>\n");
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("jmaki.runtime.Log");
        }
        return logger;
    }
}

