/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.client.util.SCRKClientHelper;
import com.sun.scn.dao.Domain;
import com.sun.scn.servicetags.SunOnlineAccount;
import com.sun.scn.servicetags.SvcTag;
import com.sun.scn.servicetags.util.XMLUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegSender {
    private static Logger log = Logger.getLogger(RegSender.class.getName());
    public static final String URL_PROPERTY_KEY = RegSender.class.getName() + ".prsUrl";
    private static final String DEFAULT_URL = "https://sunconnection.sun.com";
    private static final String DEFAULT_URI = "ProductRegistrationService/";

    private static String getBaseUrl() {
        String baseUrl;
        try {
            ResourceBundle resources = ResourceBundle.getBundle("com.sun.scn.client.resources.Connection");
            String target = resources.getString("target");
            baseUrl = resources.getString(target + ".prs.url");
        }
        catch (Exception e) {
            baseUrl = DEFAULT_URL;
        }
        String tmp = System.getProperty(URL_PROPERTY_KEY);
        if (tmp != null) {
            baseUrl = tmp;
        }
        baseUrl = baseUrl.endsWith("/") ? baseUrl + DEFAULT_URI : baseUrl + "/ProductRegistrationService/";
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using base url: " + baseUrl);
        }
        return baseUrl;
    }

    private static Document readErrorDocument(InputStream in) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            boolean bodyFlag = false;
            boolean responseFlag = false;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                if (line.toUpperCase().indexOf("<RESPONSE>") >= 0 && bodyFlag) {
                    responseFlag = true;
                }
                if (line.toUpperCase().indexOf("<BODY>") >= 0) {
                    bodyFlag = true;
                }
                if (bodyFlag && responseFlag) {
                    sb.append(line);
                    sb.append("\n");
                }
                if (line.toUpperCase().indexOf("</BODY>") >= 0) {
                    bodyFlag = false;
                }
                if (line.toUpperCase().indexOf("</RESPONSE>") < 0) continue;
                responseFlag = false;
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                return builder.parse(new InputSource(new StringReader(sb.toString())));
            }
            catch (ParserConfigurationException pce) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Encountered error: " + pce.getMessage(), pce);
                }
                return null;
            }
            catch (SAXException se) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Encountered error: " + se.getMessage(), se);
                }
                return null;
            }
        }
        catch (IOException ioe) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Encountered error: " + ioe.getMessage(), ioe);
            }
            return null;
        }
    }

    private static Document readDocument(InputStream in) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        while ((line = bin.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(sb.toString())));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            System.err.println("offending xml: " + sb.toString());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "exception", e);
            }
            throw new RuntimeException(e);
        }
    }

    public static void createSunOnlineAccount(SunOnlineAccount soa) throws SvcTagException {
        RegSender.createSunOnlineAccount(soa, null, -1);
    }

    public static void createSunOnlineAccount(SunOnlineAccount soa, String proxyHost, int proxyPort) throws SvcTagException {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Creating sun online account");
        }
        soa.setTouVersion("SMI_TOU_1.2");
        soa.setTouResponse("Accepted");
        Document response = RegSender.doHttpOp("POST", RegSender.getBaseUrl(), "soa", soa.toXMLRequestString(), null, null, proxyHost, proxyPort);
        if (response == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Null response from post");
            }
            throw new SvcTagException(0);
        }
        NodeList responses = response.getElementsByTagName("response");
        if (responses != null && responses.getLength() > 0) {
            Element e = (Element)responses.item(0);
            String status = XMLUtil.getOptionalTextValue(e, "status");
            String detail = XMLUtil.getOptionalTextValue(e, "detail");
            if (status != null && status.equals("success")) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Successfully created account");
                }
                return;
            }
            if (status == null || detail == null) {
                throw new SvcTagException(0);
            }
            if (detail.contains("VALIDATION_ERROR")) {
                if (detail.contains("Email Address must be in a valid format")) {
                    throw new SvcTagException(7, "Email Address must be in a valid format");
                }
                if (detail.contains("Password must be at least 6 characters")) {
                    throw new SvcTagException(10, "Password must be at least 6 characters");
                }
            } else {
                if (detail.contains("DRPL_MATCH")) {
                    throw new SvcTagException(11, "Error creating account");
                }
                if (detail.contains("DUPLICATE_USERNAME")) {
                    throw new SvcTagException(9, "Username already exists");
                }
                if (detail.contains("Invalid Country Name")) {
                    throw new SvcTagException(8, "Invalid Country Provided");
                }
            }
        }
        throw new SvcTagException(0);
    }

    public static List<Domain> getUserDomains(String soaId, KeyPair keyPair, String clientId) throws SvcTagException {
        return RegSender.getUserDomains(soaId, null, -1, keyPair, clientId);
    }

    public static List<Domain> getUserDomains(String soaId, String proxyHost, int proxyPort, KeyPair keyPair, String clientId) throws SvcTagException {
        Document doc;
        String destBaseUrl = RegSender.getBaseUrl();
        ArrayList<Domain> domains = new ArrayList<Domain>();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Getting domains for: " + soaId);
        }
        if ((doc = RegSender.doHttpOp("GET", destBaseUrl, "domain/" + soaId, soaId, keyPair, clientId, proxyHost, proxyPort)) != null) {
            NodeList list = doc.getElementsByTagName("domain");
            for (int i = 0; i < list.getLength(); ++i) {
                try {
                    Domain d = new Domain((Element)list.item(i));
                    domains.add(d);
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.log(Level.FINER, "found role/domain: " + d.getDomainName());
                    continue;
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "Error: " + e.getMessage(), e);
                }
            }
        } else if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "No domains found for: " + soaId);
        }
        return domains;
    }

    public static SvcTag getSvcTag(String destUrlPath, KeyPair keyPair, String clientId, int domainId) throws SvcTagException {
        return RegSender.getSvcTag(destUrlPath, null, -1, keyPair, clientId, domainId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SvcTag getSvcTag(String destUrlPath, String proxyHost, int proxyPort, KeyPair keyPair, String clientId, int domainId) throws SvcTagException {
        String destBaseUrl = RegSender.getBaseUrl();
        SvcTagException ste = null;
        SvcTag st = null;
        HttpURLConnection con = null;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Getting svctag information: " + destUrlPath);
        }
        try {
            URL url = new URL(destBaseUrl + destUrlPath);
            if (proxyHost != null && !proxyHost.equals("") && proxyPort != -1) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Using proxy: " + proxyHost + ":" + proxyPort);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                con = (HttpURLConnection)url.openConnection(proxy);
            } else {
                con = (HttpURLConnection)url.openConnection();
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            con.setRequestMethod("GET");
            con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            con.setRequestProperty("User-Agent", "ServiceTag Collector");
            String payload = "" + domainId;
            String signature = new String(SCRKClientHelper.signPayload(payload, keyPair.getPrivate()));
            con.setRequestProperty("client_reg_id", clientId);
            con.setRequestProperty("payload_sig", signature);
            con.setRequestProperty("payload", payload);
            con.connect();
            if (con.getResponseCode() == 401) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "unauthorized response code: " + con.getResponseCode());
                }
                ste = new SvcTagException(12);
            } else if (con.getResponseCode() >= 400) {
                if (log.isLoggable(Level.FINE)) {
                    if (con.getResponseCode() == 400) {
                        log.log(Level.FINE, "Service tag not found or registered");
                    } else {
                        log.log(Level.FINE, "error response code: " + con.getResponseCode());
                    }
                }
                ste = new SvcTagException(14, RegSender.readErrorDocument(con.getErrorStream()));
            } else {
                int j = 0;
                Document response = RegSender.readDocument(con.getInputStream());
                NodeList svcTagNodes = response.getElementsByTagName("service_tag");
                if (j < svcTagNodes.getLength()) {
                    Element svcTagElement = (Element)svcTagNodes.item(j);
                    st = new SvcTag(XMLUtil.getRequiredTextValue(svcTagElement, "instance_urn"));
                    st.setState(svcTagElement);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "found svctag: " + st.toXMLString());
                    }
                }
            }
        }
        catch (ConnectException ce) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "connect exception: " + ce.getMessage(), ce);
            }
            ste = new SvcTagException(13);
        }
        catch (IOException ioe) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "io exception: " + ioe.getMessage(), ioe);
            }
            ste = new SvcTagException(15, ioe.getMessage());
        }
        if (ste != null) {
            throw ste;
        }
        return st;
    }

    public static Document sendPut(Element e, String destUrlPath, String proxyHost, int proxyPort, KeyPair keyPair, String clientId) throws SvcTagException {
        return RegSender.sendElement(e, destUrlPath, proxyHost, proxyPort, keyPair, clientId, "PUT");
    }

    public static Document sendPut(Element e, String destUrlPath, KeyPair keyPair, String clientId) throws SvcTagException {
        return RegSender.sendElement(e, destUrlPath, null, -1, keyPair, clientId, "PUT");
    }

    public static Document sendPost(Element e, String destUrlPath, String proxyHost, int proxyPort, KeyPair keyPair, String clientId) throws SvcTagException {
        return RegSender.sendElement(e, destUrlPath, proxyHost, proxyPort, keyPair, clientId, "POST");
    }

    public static Document sendPost(Element e, String destUrlPath, KeyPair keyPair, String clientId) throws SvcTagException {
        return RegSender.sendElement(e, destUrlPath, null, -1, keyPair, clientId, "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document sendElement(Element e, String destUrlPath, String proxyHost, int proxyPort, KeyPair keyPair, String clientId, String requestMethod) throws SvcTagException {
        String destBaseUrl = RegSender.getBaseUrl();
        HttpURLConnection con = null;
        SvcTagException ste = null;
        Document response = null;
        try {
            URL url = new URL(destBaseUrl + destUrlPath);
            if (proxyHost != null && !proxyHost.equals("") && proxyPort != -1) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Using proxy: " + proxyHost + ":" + proxyPort);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                con = (HttpURLConnection)url.openConnection(proxy);
            } else {
                con = (HttpURLConnection)url.openConnection();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Sending " + requestMethod + "to: " + url);
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            con.setRequestMethod(requestMethod);
            con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            con.setRequestProperty("User-Agent", "ServiceTag Collector");
            ByteArrayOutputStream payloadWriter = new ByteArrayOutputStream();
            XMLUtil.writeElement(e, payloadWriter);
            String payload = new String(payloadWriter.toByteArray());
            payload = payload.replace("\r", "");
            String signature = new String(SCRKClientHelper.signPayload(payload, keyPair.getPrivate()));
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Sending payload: " + payload);
            }
            con.setRequestProperty("client_reg_id", clientId);
            con.setRequestProperty("payload_sig", signature);
            con.connect();
            OutputStream urlOut = con.getOutputStream();
            urlOut.write(payload.getBytes());
            urlOut.flush();
            urlOut.close();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Response code: " + con.getResponseCode());
                log.log(Level.FINER, "Response message: " + con.getResponseMessage());
            }
            if (con.getResponseCode() == 401) {
                ste = new SvcTagException(12);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Invalid username/pwd");
                }
                throw ste;
            }
            if (con.getResponseCode() >= 400) {
                ste = new SvcTagException(14, RegSender.readErrorDocument(con.getErrorStream()));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Invalid response code");
                }
                throw ste;
            }
            response = RegSender.readDocument(con.getInputStream());
        }
        catch (UnknownHostException uhe) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "unknown host exception", uhe);
            }
            ste = new SvcTagException(13);
        }
        catch (ConnectException ce) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "connect exception", ce);
            }
            ste = new SvcTagException(13);
        }
        catch (IOException ioe) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "io exception", ioe);
            }
            ste = new SvcTagException(15, ioe.getMessage());
        }
        if (ste != null) {
            throw ste;
        }
        return response;
    }

    private static Document doHttpOp(String operation, String baseUrl, String uri, String payload, KeyPair keyPair, String clientId, String proxyHost, int proxyPort) throws SvcTagException {
        block32: {
            try {
                String targetURL = baseUrl + uri;
                URL url = new URL(targetURL);
                HttpURLConnection con = null;
                if (proxyHost != null && !proxyHost.equals("") && proxyPort != -1) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Using proxy: " + proxyHost + ":" + proxyPort);
                    }
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                    con = (HttpURLConnection)url.openConnection(proxy);
                } else {
                    con = (HttpURLConnection)url.openConnection();
                }
                con.setRequestMethod(operation);
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setAllowUserInteraction(false);
                con.setUseCaches(false);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Sending " + operation + "to: " + url);
                }
                con.setRequestProperty("User-Agent", "User Interface");
                con.setRequestProperty("Content-Type", "text/xml;charset=\"utf-8\"");
                if (keyPair != null && clientId != null) {
                    String signature = new String(SCRKClientHelper.signPayload(payload, keyPair.getPrivate()));
                    con.setRequestProperty("client_reg_id", clientId);
                    con.setRequestProperty("payload_sig", signature);
                    con.setRequestProperty("payload", payload);
                }
                con.connect();
                if (payload != null && (operation.equals("POST") || operation.equals("PUT"))) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Payload: " + payload);
                    }
                    OutputStream urlOut = con.getOutputStream();
                    urlOut.write(payload.getBytes());
                    urlOut.flush();
                    urlOut.close();
                }
                int responseCode = con.getResponseCode();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Response code: " + con.getResponseCode());
                    log.log(Level.FINER, "Response message: " + con.getResponseMessage());
                }
                if (responseCode < 400) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuffer sb = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                    String response = sb.toString();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Response: " + response);
                    }
                    try {
                        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dbuilder = dbfactory.newDocumentBuilder();
                        return dbuilder.parse(new InputSource(new StringReader(response)));
                    }
                    catch (ParserConfigurationException pce) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "exception while configuring parser", pce);
                        }
                        break block32;
                    }
                    catch (SAXException ex) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "sax exception", ex);
                        }
                        break block32;
                    }
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getErrorStream()));
                StringBuffer sb = new StringBuffer();
                String line = null;
                boolean flag = false;
                while ((line = br.readLine()) != null) {
                    if (line.indexOf("<HTML>") >= 0) {
                        flag = true;
                        line = line.substring(line.indexOf("<HTML>"));
                    }
                    if (!flag) continue;
                    sb.append(line);
                    sb.append("\n");
                }
                br.close();
                String response = sb.toString();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Error Response: " + response);
                }
                try {
                    DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dbuilder = dbfactory.newDocumentBuilder();
                    return dbuilder.parse(new InputSource(new StringReader(response)));
                }
                catch (ParserConfigurationException pce) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "parser configuration exception", pce);
                    }
                }
                catch (SAXException ex) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "sax exception", ex);
                    }
                }
            }
            catch (ConnectException ce) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "connect exception: " + ce.getMessage(), ce);
                }
                throw new SvcTagException(13);
            }
            catch (UnknownHostException uhe) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "exception", uhe);
                }
                throw new SvcTagException(16);
            }
            catch (MalformedURLException mue) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "exception", mue);
                }
                throw new SvcTagException(17);
            }
            catch (IOException ex) {
                if (!log.isLoggable(Level.FINEST)) break block32;
                log.log(Level.FINEST, "exception", ex);
            }
        }
        return null;
    }

    private static String getAuthHeader(String user, String pass) {
        Base64 base64 = new Base64();
        String s = user + ":" + pass;
        String header = "Basic " + new String(base64.encode(s.getBytes()));
        return header;
    }

    static {
        Authenticator.setDefault(null);
    }
}

