/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

public class CInteger {
    private long max;
    private long val;

    public CInteger(long maxValue) {
        if (maxValue <= 0L) {
            throw new IllegalArgumentException();
        }
        this.max = maxValue;
        this.setValue(0L);
    }

    public void inc() {
        this.val = this.val != this.max ? ++this.val : 0L;
    }

    public void setValue(long newValue) {
        if (newValue < 0L || newValue > this.max) {
            throw new IllegalArgumentException();
        }
        this.val = newValue;
    }

    public long getValue() {
        return this.val;
    }

    public long nextValue() {
        if (this.val != this.max) {
            return this.val + 1L;
        }
        return 0L;
    }

    public long prevValue() {
        if (this.val != 0L) {
            return this.val - 1L;
        }
        return this.max;
    }

    public boolean equals(long value) {
        return this.val == value;
    }

    public int compareTo(long rhs) {
        if (this.val == rhs) {
            return 0;
        }
        if (this.val < rhs && rhs - this.val < this.max / 2L || this.val > rhs && this.val - rhs > this.max / 2L) {
            return -1;
        }
        return 1;
    }
}

