/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CInteger;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.Dialog;
import com.sun.hadb.comm.DialogManager;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.MsgChannel;
import com.sun.hadb.comm.MsgInfo;
import com.sun.hadb.comm.MsgManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DialogImpl
implements Dialog {
    private static final int DLG_FREE = 0;
    private static final int DLG_SEND_M = 1;
    private static final int DLG_RECV_M = 2;
    private static final int DLG_LAST_M = 3;
    private static final int DLG_SEND_S = 16;
    private static final int DLG_RECV_S = 17;
    private static final int DLG_LAST_S = 18;
    private static final int DLG_CLOSED = 255;
    private Logger logger = CommLogFactory.getCommLogger();
    private int dialog_state;
    private boolean is_master;
    private int my_dialog_id;
    private CInteger outRound;
    private CInteger inRound;
    private int outFlags;
    private EndPoint my_endpoint;
    private DialogManager my_manager;
    private MessageBuffer outMsg;
    private MsgInfo[] inMsg;
    private MsgChannel msgchannel;
    private long msgkey;
    private boolean retrans;

    public DialogImpl(DialogManager manager, int dialog_id, EndPoint endpoint, boolean retrans, boolean master) throws CommException {
        this.my_dialog_id = dialog_id;
        this.my_manager = manager;
        this.my_endpoint = endpoint;
        this.is_master = master;
        this.outRound = new CInteger(255L);
        this.inRound = new CInteger(255L);
        if (master) {
            this.dialog_state = 1;
            this.outFlags = 3;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("DialogImpl: Creating new MASTER dialog with id=" + dialog_id);
            }
        } else {
            this.dialog_state = 0;
            this.outFlags = 0;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("DialogImpl: Creating new SLAVE dialog with id=" + dialog_id);
            }
        }
        if (retrans) {
            this.outFlags |= 8;
        }
        this.inMsg = new MsgInfo[1];
        this.inMsg[0] = null;
        MsgManager man = MsgManager.getInstance();
        this.msgkey = 0L;
        this.retrans = retrans;
        this.msgchannel = man.openChannel(endpoint);
    }

    public EndPoint getEndPoint() {
        return this.my_endpoint;
    }

    public void close() {
        if (this.dialog_state != 255) {
            this.my_manager.close(this);
            this.dialog_state = 255;
            if (this.msgchannel != null) {
                this.msgchannel.close();
                this.msgchannel = null;
            }
        }
    }

    public void finalize() {
        this.close();
    }

    public synchronized void send(MessageBuffer buffer, boolean is_last) throws CommException {
        if (is_last) {
            this.logger.finest("DialogImpl.send() : Sending last message on dialog");
            this.outFlags |= 4;
        }
        switch (this.dialog_state) {
            case 1: {
                this.outRound.inc();
                break;
            }
            case 16: {
                break;
            }
            default: {
                CommException ce = new CommException(16);
                this.logger.log(Level.FINE, "DialogImpl.send1: Illegal state: " + this.dialog_state, ce);
                throw ce;
            }
        }
        MessageChunkByteArray chunk = new MessageChunkByteArray();
        chunk.appendUInt16(this.my_dialog_id);
        ((MessageChunk)chunk).appendUInt8((int)this.outRound.getValue());
        ((MessageChunk)chunk).appendUInt8(this.outFlags);
        buffer.prepend(chunk);
        this.outMsg = buffer;
        this.msgchannel.send(buffer, this.msgkey, 4, this.retrans);
        switch (this.dialog_state) {
            case 1: {
                if (!is_last) {
                    this.dialog_state = 2;
                    break;
                }
                this.dialog_state = 3;
                break;
            }
            case 16: {
                this.dialog_state = 17;
                break;
            }
            default: {
                this.logger.severe("DialogImpl.send2: Illegal state: " + this.dialog_state);
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("send: new state: " + this.dialog_state);
        }
    }

    public void send(MessageBuffer buffer) throws CommException {
        this.send(buffer, false);
    }

    public synchronized void retryMsg() throws CommException {
        this.logger.finest("DialogImpl.retryMsg");
        if (this.retrans) {
            throw new CommException(15);
        }
        switch (this.dialog_state) {
            case 2: 
            case 3: {
                this.msgchannel.send(this.outMsg, this.msgkey, 4, false);
                break;
            }
            default: {
                throw new CommException(16);
            }
        }
    }

    public synchronized void ignoreReply() {
        switch (this.dialog_state) {
            case 1: {
                this.inMsg[0] = null;
                break;
            }
            case 2: {
                this.dialog_state = 1;
                this.inRound.inc();
                this.outFlags &= 0xFFFFFFFD;
                break;
            }
            default: {
                this.logger.finer("DialogImpl.ignoreReply: illegal state: " + this.dialog_state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgInfo receive() throws CommException {
        MsgInfo[] msgInfoArray = this.inMsg;
        synchronized (this.inMsg) {
            while (this.inMsg[0] == null) {
                try {
                    this.inMsg.wait();
                }
                catch (InterruptedException e) {}
            }
            MsgInfo tmpMsg = this.inMsg[0];
            this.inMsg[0] = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmpMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgInfo receive(long timeout) {
        MsgInfo[] msgInfoArray = this.inMsg;
        synchronized (this.inMsg) {
            if (this.inMsg[0] == null) {
                long timelimit = System.currentTimeMillis() + timeout;
                do {
                    try {
                        this.inMsg.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (this.inMsg[0] == null && System.currentTimeMillis() < timelimit);
                if (this.inMsg[0] == null) {
                    this.logger.finer("DialogImpl.receive: TIME OUT");
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return null;
                }
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("DialogImpl.receive: response time: " + (System.currentTimeMillis() - (timelimit - timeout)));
                }
            }
            MsgInfo tmpMsg = this.inMsg[0];
            this.inMsg[0] = null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return tmpMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void receive_handler(int dialog_id, int round, int flags, MsgInfo msginfo) {
        switch (this.dialog_state) {
            case 0: {
                if ((flags & 2) != 0 && round != 1) {
                    this.logger.severe("DialogImpl.receive_handler(freeState): not a valid message");
                    return;
                }
                this.dialog_state = (flags & 4) == 0 ? 16 : 18;
                this.outFlags = flags & 0xFFFFFFFC;
                this.outRound.setValue(round);
                this.retrans = (flags & 8) != 0;
                if (!this.logger.isLoggable(Level.FINEST)) break;
                this.logger.finest("receiver: new state: " + this.dialog_state);
                break;
            }
            case 2: {
                if ((long)round != this.inRound.nextValue()) {
                    if (this.inRound.compareTo(round) >= 0) {
                        this.logger.finer("DialogImpl.receive_handler(recvStateM): duplicate");
                        return;
                    }
                    if (this.logger.isLoggable(Level.FINEST)) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("DialogImpl.receive_handler(recvStateM): ").append(" out of sequence: did=").append(this.my_dialog_id).append(" round=").append(round).append(", should be ").append(this.inRound.nextValue());
                        this.logger.finest(sb.toString());
                    }
                    return;
                }
                this.dialog_state = 1;
                this.outFlags &= 0xFFFFFFFD;
                break;
            }
            case 3: {
                if ((long)round != this.inRound.nextValue()) {
                    if (this.inRound.compareTo(round) >= 0) {
                        this.logger.finer("DialogImpl.receive_handler(lastStateM): duplicate");
                        return;
                    }
                    if (this.logger.isLoggable(Level.FINEST)) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("DialogImpl.receive_handler(lastStateM): ").append(" out of sequence: did=").append(this.my_dialog_id).append(" round=").append(round).append(", should be ").append(this.inRound.nextValue());
                        this.logger.finest(sb.toString());
                    }
                    return;
                }
                if ((flags & 4) != 0) break;
                this.logger.finer("DialogImpl.receive_handler(lastStateM): missing D_CLOSE flag");
                return;
            }
            case 17: {
                if (this.inRound.compareTo(round) >= 0) {
                    if ((long)round == this.inRound.getValue()) {
                        if (!this.retrans && this.outMsg != null) {
                            try {
                                this.msgchannel.send(this.outMsg, this.msgkey, 4, false);
                            }
                            catch (CommException e) {
                                this.logger.log(Level.FINE, "DialogImpl.receive_handler(recvStateS): Exception: ", e);
                            }
                        }
                        return;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("DialogImpl.receive_handler(recvStateS): ").append(" out of sequence: did=").append(this.my_dialog_id).append(" round=").append(round).append(", should be ").append(this.inRound.nextValue());
                    this.logger.finer(sb.toString());
                    return;
                }
                this.dialog_state = (flags & 4) == 0 ? 16 : 18;
                this.outFlags = flags & 0xFFFFFFFE;
                this.outRound.setValue(round);
                break;
            }
            case 16: {
                if (this.inRound.compareTo(round) >= 0) {
                    if ((long)round == this.inRound.getValue()) {
                        return;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("DialogImpl.receive_handler(sendStateS): ").append(" out of sequence: did=" + this.my_dialog_id + " round=" + round + ", should be " + this.inRound.nextValue());
                    this.logger.finer(sb.toString());
                    return;
                }
                this.dialog_state = (flags & 4) == 0 ? 16 : 18;
                this.outFlags = flags & 0xFFFFFFFE;
                this.outRound.setValue(round);
                break;
            }
            case 18: {
                if ((long)round == this.inRound.getValue()) {
                    return;
                }
                this.logger.finer("DialogImpl.receive_handler(lastStateS):  out of sequence: did=" + this.my_dialog_id + " round=" + round + ", should be " + this.inRound.nextValue());
                return;
            }
            default: {
                this.logger.finer("DialogImpl.receive_handler: did: " + dialog_id + " master: " + this.is_master + " illegal state: " + this.dialog_state);
                return;
            }
        }
        this.inRound.setValue(round);
        MsgInfo[] msgInfoArray = this.inMsg;
        synchronized (this.inMsg) {
            this.inMsg[0] = msginfo;
            this.inMsg.notify();
            // ** MonitorExit[var5_10] (shouldn't be in output)
            return;
        }
    }

    public void setMessageKey(long msgkey) {
        this.msgkey = msgkey;
    }

    public boolean isMaster() {
        return this.is_master;
    }

    public int getDialogId() {
        return this.my_dialog_id;
    }
}

