/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import java.net.InetAddress;

public class EndPoint {
    private String protocol_name;
    private String host_name;
    private int port_no;
    private InetAddress inet_address;

    public EndPoint(String host, int port) {
        if (host == null) {
            host = "";
        }
        this.host_name = host.trim();
        this.port_no = port;
        this.protocol_name = "UDP";
        try {
            this.inet_address = InetAddress.getByName(this.host_name);
        }
        catch (Exception e) {
            this.inet_address = null;
        }
    }

    public EndPoint(InetAddress address, int port) {
        this.inet_address = address;
        this.port_no = port;
        this.host_name = "";
        this.protocol_name = "UDP";
    }

    public String getHost() {
        return this.host_name;
    }

    public int getPort() {
        return this.port_no;
    }

    public String getProtocol() {
        return this.protocol_name;
    }

    public InetAddress getAddress() {
        return this.inet_address;
    }

    public String toString() {
        return this.inet_address.toString() + ':' + this.port_no;
    }

    public int hashCode() {
        return this.inet_address.hashCode() + this.port_no;
    }

    public boolean equals(Object obj) {
        try {
            EndPoint e = (EndPoint)obj;
            if (e.getPort() == this.port_no) {
                return this.hashCode() == e.hashCode();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }
}

