/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageBuffer;
import java.io.InputStream;

public class ExtDataInputStream
extends InputStream {
    private ExtData p;
    private int maxoffset;
    private int currpos = 0;

    public ExtDataInputStream(ExtData p, int maxoffset) {
        this.p = p;
        this.maxoffset = maxoffset;
    }

    public int read() {
        return this.currpos < this.maxoffset ? this.p.getUInt8(this.currpos++) : -1;
    }

    public int available() {
        return this.maxoffset - this.currpos;
    }

    public void close() {
        this.p = null;
    }

    public static boolean test() {
        try {
            ExtData tst = new ExtData(new MessageBuffer(15));
            tst.putInt8((byte)0, 0);
            tst.putInt16((short)2, 2);
            tst.putInt32(5, 5);
            tst.putInt32(8, 8);
            ExtDataInputStream s = new ExtDataInputStream(tst, 15);
            byte[] res = new byte[15];
            int i = s.read(res, 0, 15);
            System.out.println(i + " " + ExtData.byteToHexString(res));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        ExtDataInputStream.test();
    }
}

