/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.UnsignedByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class MessageChunkByteArray
extends MessageChunk
implements UnsignedByteBuffer,
Cloneable {
    private static final int DEFAULT_APPEND_SIZE = 200;
    private byte[] buffer;
    private int startptr;
    private int stopptr;
    private int realloc_count = 0;

    public MessageChunkByteArray() {
        this.setupBuffers(200);
    }

    public MessageChunkByteArray(int appendsize) {
        if (appendsize < 0) {
            appendsize = 200;
        }
        this.setupBuffers(appendsize);
    }

    public MessageChunkByteArray(byte[] buf, int length) {
        this.setupBuffers(length);
        System.arraycopy(buf, 0, this.buffer, 0, length);
        this.stopptr += length;
    }

    public MessageChunkByteArray(ByteBuffer buf) {
        this.setupBuffers(buf.limit());
        this.stopptr += buf.limit();
        buf.get(this.buffer, 0, buf.limit());
    }

    public MessageChunkByteArray(InputStream indata) throws IOException {
        this.setupBuffers(65536);
        int b = indata.read();
        while (b >= 0) {
            this.appendUInt8(b);
            b = indata.read();
        }
    }

    public Object clone() {
        int size = this.size();
        MessageChunkByteArray clone = new MessageChunkByteArray(size);
        System.arraycopy(this.buffer, this.startptr, clone.buffer, 0, size);
        clone.stopptr = size;
        return clone;
    }

    public void close() {
        this.buffer = null;
    }

    public MessageChunkByteArray(byte[] buf) {
        this.setupBuffers(buf.length);
        System.arraycopy(buf, 0, this.buffer, 0, buf.length);
        this.stopptr += buf.length;
    }

    private void setupBuffers(int appendsize) {
        this.buffer = new byte[appendsize];
        this.stopptr = this.startptr = 0;
    }

    private void reallocate() {
        int orgsize = this.buffer.length;
        int oldstart = orgsize / 2;
        byte[] newbuf = new byte[orgsize * 2];
        System.arraycopy(this.buffer, 0, newbuf, oldstart, orgsize);
        this.buffer = newbuf;
        this.startptr += oldstart;
        this.stopptr += oldstart;
        ++this.realloc_count;
    }

    private void ensureSpace(int size) {
        int orgsize = this.buffer.length;
        int oldstart = orgsize / 2;
        int whatsleft = this.buffer.length - this.startptr;
        int need = size - whatsleft;
        if (need > 0) {
            byte[] newbuf = new byte[need + orgsize];
            System.arraycopy(this.buffer, 0, newbuf, oldstart, orgsize);
            this.buffer = newbuf;
            this.startptr += oldstart;
            this.stopptr += oldstart;
            ++this.realloc_count;
        }
    }

    public int size() {
        return this.stopptr - this.startptr;
    }

    public ExtData allocate(int size) {
        this.ensureSpace(size);
        this.stopptr += size;
        return new ExtData(this);
    }

    public void appendUInt8(int value) {
        if (this.stopptr == this.buffer.length) {
            this.reallocate();
        }
        this.buffer[this.stopptr] = (byte)(value & 0xFF);
        ++this.stopptr;
    }

    public int getUInt8() throws IndexOutOfBoundsException {
        if (this.startptr < this.stopptr) {
            byte a = this.buffer[this.startptr];
            ++this.startptr;
            if (a < 0) {
                return 256 + a;
            }
            return a;
        }
        throw new IndexOutOfBoundsException("tried to read beyond buffer");
    }

    public int getUInt8(int offset) throws IndexOutOfBoundsException {
        byte a = this.buffer[this.startptr + offset];
        if (a < 0) {
            return 256 + a;
        }
        return a;
    }

    public void putUInt8(int v, int offset) throws IndexOutOfBoundsException {
        this.buffer[this.startptr + offset] = (byte)(v & 0xFF);
    }

    public void putBytes(byte[] v, int offset) throws IndexOutOfBoundsException {
        System.arraycopy(v, 0, this.buffer, this.startptr + offset, v.length);
    }

    public int putByteStream(InputStream stream, int length, int offset) throws IndexOutOfBoundsException, IOException {
        return stream.read(this.buffer, this.startptr + offset, length);
    }

    public byte[] getBytes(int offset, int count) throws IndexOutOfBoundsException {
        byte[] barr = new byte[count];
        System.arraycopy(this.buffer, this.startptr + offset, barr, 0, count);
        return barr;
    }

    public void get(byte[] dst, int offset) {
        System.arraycopy(this.buffer, this.startptr, dst, offset, this.stopptr - this.startptr);
    }

    public void get(ByteBuffer dst) {
        dst.put(this.buffer, this.startptr, this.stopptr - this.startptr);
    }

    public MessageChunk getFragment(int offset, int count) {
        MessageChunkByteArray newChunk;
        if (offset < 0 || count <= 0) {
            throw new IllegalArgumentException();
        }
        if (offset + count > this.size()) {
            throw new IndexOutOfBoundsException("Fragment outside chunk");
        }
        if (offset == 0 && count == this.size()) {
            newChunk = this;
        } else {
            byte[] chunkData = this.getBytes(offset, count);
            newChunk = new MessageChunkByteArray(chunkData, count);
        }
        return newChunk;
    }

    public String getString(int offset, int count) throws IndexOutOfBoundsException {
        return new String(this.buffer, this.startptr + offset, count);
    }

    public byte[] getChunk() {
        byte[] buf = new byte[this.size()];
        System.arraycopy(this.buffer, this.startptr, buf, 0, this.size());
        return buf;
    }

    public String toString() {
        String s = "len=" + this.buffer.length + ":siz=" + this.size() + ":startptr=" + this.startptr + ":stopptr=" + this.stopptr + ":reallocs=" + this.realloc_count;
        return s;
    }
}

