/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.MsgBufferPool;
import com.sun.hadb.comm.UnsignedByteBuffer;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class MessageChunkByteBuffer
extends MessageChunk
implements UnsignedByteBuffer,
Cloneable {
    private ByteBuffer byteBuffer = null;

    public MessageChunkByteBuffer(ByteBuffer buf) {
        this.byteBuffer = buf;
    }

    public Object clone() {
        throw new ReadOnlyBufferException();
    }

    public synchronized void close() {
        if (this.byteBuffer != null) {
            MsgBufferPool.getInstance().returnMsgBuffer(this.byteBuffer);
            this.byteBuffer = null;
        }
    }

    public int size() {
        return this.byteBuffer.remaining();
    }

    public ExtData allocate(int size) {
        throw new ReadOnlyBufferException();
    }

    public void appendUInt8(int value) {
        throw new ReadOnlyBufferException();
    }

    public int getUInt8() {
        return this.byteBuffer.get() & 0xFF;
    }

    public int getUInt16() {
        return this.byteBuffer.getShort() & 0xFFFF;
    }

    public long getUInt32() {
        return (long)this.byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public int getUInt8(int offset) {
        return this.byteBuffer.get(this.byteBuffer.position() + offset) & 0xFF;
    }

    public int getUInt16(int offset) {
        return this.byteBuffer.getShort(this.byteBuffer.position() + offset) & 0xFFFF;
    }

    public long getUInt32(int offset) {
        return (long)this.byteBuffer.getInt(this.byteBuffer.position() + offset) & 0xFFFFFFFFL;
    }

    public int getInt32() {
        return this.byteBuffer.getInt() ^ Integer.MIN_VALUE;
    }

    public void putUInt8(int v, int offset) {
        throw new ReadOnlyBufferException();
    }

    public void putBytes(byte[] v, int offset) {
        throw new ReadOnlyBufferException();
    }

    public int putByteStream(InputStream stream, int length, int offset) {
        throw new ReadOnlyBufferException();
    }

    public byte[] getBytes(int offset, int count) {
        byte[] barr = new byte[count];
        this.byteBuffer.mark();
        this.byteBuffer.position(this.byteBuffer.position() + offset);
        this.byteBuffer.get(barr);
        this.byteBuffer.reset();
        return barr;
    }

    public void get(byte[] dst, int offset) {
        this.byteBuffer.mark();
        this.byteBuffer.get(dst, offset, this.byteBuffer.remaining());
        this.byteBuffer.reset();
    }

    public void get(ByteBuffer dst) {
        this.byteBuffer.mark();
        dst.put(this.byteBuffer);
        this.byteBuffer.reset();
    }

    public MessageChunk getFragment(int offset, int count) {
        MessageChunk newChunk;
        if (offset < 0 || count <= 0) {
            throw new IllegalArgumentException();
        }
        if (offset + count > this.size()) {
            throw new IndexOutOfBoundsException("Fragment outside chunk");
        }
        System.out.println("MessageChunkByteBuffer.getFragment");
        if (offset == 0 && count == this.size()) {
            newChunk = this;
        } else {
            byte[] chunkData = this.getBytes(offset, count);
            newChunk = new MessageChunkByteArray(chunkData, count);
        }
        return newChunk;
    }

    public String getString(int offset, int count) throws IndexOutOfBoundsException {
        System.out.println("MessageChunkByteBuffer.getString");
        byte[] buf = new byte[count];
        for (int i = 0; i < count; ++i) {
            buf[i] = this.byteBuffer.get(offset + i);
        }
        return new String(buf);
    }

    public byte[] getChunk() {
        System.out.println("MessageChunkByteBuffer.getChunk");
        byte[] buf = new byte[this.size()];
        this.byteBuffer.mark();
        this.byteBuffer.get(buf);
        this.byteBuffer.rewind();
        return buf;
    }

    public String toString() {
        String s = "capacity=" + this.byteBuffer.capacity() + " limit=" + this.byteBuffer.limit() + " position=" + this.byteBuffer.position();
        return s;
    }
}

