/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;

public class MsgHeader {
    static final int MSGVERSION_CURR = 5;
    static final int MSGVERSION_PREV = 4;
    static final int MSGVERSION_AUTO = 254;
    private static final int PROTOVERSION = 5;
    static final int MSG_HEADER_SIZE = 23;
    static final int MSG_HEADER_SIZE_LONGMSG = 27;
    private static final int MSG_ACK = 8;
    private static final int MSG_RESEND = 16;
    private static final int MSG_RESEND_FROM = 32;
    private static final int MSG_NO_RETRANS = 64;
    private static final int MSG_RESET_SEQ = 128;
    private static final int MSG_UPGRADE = 128;
    static final int VOID_MSGPARTNO = 255;
    static final long VOID_CONNECTIONID = 0L;
    private long msgKey = 2903L;
    private int msgFlags;
    private int resetSeq = 0;
    private long msgSeq = 0L;
    private int partNo = 255;
    private int partOff = 0;
    private long ackSeq = 0L;
    private long outCid = 0L;
    private MessageBuffer body;

    public MsgHeader(long cid, long msgSeqNo, long key, int payload, boolean retrans, MessageBuffer body) {
        this.outCid = cid;
        this.msgSeq = msgSeqNo;
        this.msgKey = key;
        this.msgFlags = payload;
        if (!retrans) {
            this.msgFlags |= 0x40;
        }
        this.body = body;
    }

    public void setMsgKey(long key) {
        this.msgKey = key;
    }

    public void setResetSeqNo(int resetSeqNo) {
        this.resetSeq = resetSeqNo;
    }

    public void setMsgSeqNo(long seqNo) {
        this.msgSeq = seqNo;
    }

    public long getMsgSeqNo() {
        return this.msgSeq;
    }

    public void setPartNo(int partNo, int offset) {
        this.partNo = partNo;
        this.partOff = offset;
    }

    public void setAckSeqNo(long ackSeqNo) {
        this.msgFlags |= 8;
        this.ackSeq = ackSeqNo;
    }

    public boolean hasResendFlag() {
        return (this.msgFlags & 0x10) != 0;
    }

    public void setResendFrom(long seqNo) {
        this.msgFlags |= 0x20;
        this.ackSeq = seqNo;
    }

    public boolean hasResendFromFlag() {
        return (this.msgFlags & 0x20) != 0;
    }

    public void setRetrans() {
        this.msgFlags |= 0xFFFFFFBF;
    }

    public boolean getRetrans() {
        return (this.msgFlags & 0x40) == 0;
    }

    public void setResetSequenceFlag() {
        this.msgFlags |= 0x80;
    }

    public boolean hasResetSequenceFlag() {
        return (this.msgFlags & 0x80) != 0;
    }

    public long getMessageSize() {
        return 27 + this.body.size();
    }

    public long getSequenceNumber() {
        return this.msgSeq;
    }

    public MessageChunk getHeader(int msgVersion) {
        MessageChunkByteArray chunk = new MessageChunkByteArray();
        int headerSize = msgVersion == 4 ? 23 : 27;
        ((MessageChunk)chunk).appendUInt8(msgVersion);
        chunk.appendUInt32(headerSize + this.body.size());
        chunk.appendUInt32(this.msgKey);
        ((MessageChunk)chunk).appendUInt8(this.msgFlags);
        ((MessageChunk)chunk).appendUInt8(this.resetSeq);
        chunk.appendUInt32(this.msgSeq);
        ((MessageChunk)chunk).appendUInt8(this.partNo);
        if (msgVersion == 4) {
            ((MessageChunk)chunk).appendUInt8(128);
        } else {
            ((MessageChunk)chunk).appendUInt8(0);
        }
        ((MessageChunk)chunk).appendUInt8(5);
        chunk.appendUInt32(this.ackSeq);
        ((MessageChunk)chunk).appendUInt8(255);
        if (msgVersion == 5) {
            chunk.appendUInt32(this.outCid);
        }
        if (this.partNo != 255 && this.partNo != 0) {
            chunk.appendUInt32(this.partOff);
        }
        return chunk;
    }

    public MessageBuffer getMessageBody() {
        return this.body;
    }
}

